/*
 * Decompiled with CFR 0.152.
 */
package gutils;

import gutils.FormObserver;
import gutils.FormPanel;
import gutils.TabStateType;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTabbedPaneStated
extends JTabbedPane
implements FormObserver {
    ArrayList<TabStateType> tabsStates = new ArrayList();

    public void setAllStates(TabStateType state) {
        int i = 0;
        while (i < this.tabsStates.size()) {
            this.setStateAt(i, state);
            ++i;
        }
        this.fireStateChanged();
    }

    public void setAllStates(boolean state) {
        int i = 0;
        while (i < this.tabsStates.size()) {
            TabStateType currState = this.getStateAt(i);
            if (currState == TabStateType.CHECKED || currState == TabStateType.UNCHECKED) {
                this.setStateAt(i, state);
            }
            ++i;
        }
    }

    public void setStateAt(int index, TabStateType state) {
        this.tabsStates.set(index, state);
        this.tabStateChanged();
        this.fireStateChanged();
    }

    public void setStateAt(String[] tabs, TabStateType state) {
        String[] stringArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            String tabTitle = stringArray[n2];
            this.setStateAt(this.indexOfTab(tabTitle), state);
            ++n2;
        }
    }

    public void setStateAt(int index, boolean state) {
        if (TabStateType.ELSE == this.getStateAt(index)) {
            return;
        }
        this.setStateAt(index, state ? TabStateType.CHECKED : TabStateType.UNCHECKED);
    }

    public void setSelectedState(boolean state) {
        this.setStateAt(this.getSelectedIndex(), state);
    }

    private void tabStateChanged() {
        int i = 0;
        while (i < this.tabsStates.size()) {
            boolean enabled = true;
            String iconPath = null;
            TabStateType currState = this.getStateAt(i);
            if (TabStateType.CHECKED == currState) {
                iconPath = "/images/green.png";
            } else if (TabStateType.UNCHECKED == currState) {
                iconPath = "/images/red.png";
            } else if (TabStateType.ELSE == currState) {
                iconPath = null;
            } else if (TabStateType.DISABLED == currState) {
                iconPath = "/images/red.png";
                enabled = false;
            }
            ImageIcon icon = iconPath == null ? null : new ImageIcon(this.getClass().getResource(iconPath));
            this.setIconAt(i, icon);
            this.setEnabledAt(i, enabled);
            ++i;
        }
    }

    public TabStateType getStateAt(int i) {
        if (this.tabsStates.isEmpty()) {
            return TabStateType.ELSE;
        }
        return this.tabsStates.get(i);
    }

    public Component add(String title, Component component) {
        return this.add(title, component, TabStateType.UNCHECKED);
    }

    public Component add(String title, Component component, TabStateType state) {
        super.add(title, component);
        this.tabsStates.add(state);
        this.tabStateChanged();
        return component;
    }

    public Component addForm(String title, FormPanel form) {
        this.add(title, form);
        form.setFormObserver(this);
        return form;
    }

    public void formChanged(FormPanel fp) {
        int index = this.indexOfComponent(fp);
        boolean state = fp.isVerified();
        this.setStateAt(index, state);
        if (state) {
            this.setSelectedIndex(index + 1);
        }
    }

    public class MyChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JTabbedPaneStated myTabPane = (JTabbedPaneStated)e.getSource();
            myTabPane.tabStateChanged();
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/orange.png"));
            myTabPane.setIconAt(myTabPane.getSelectedIndex(), icon);
        }
    }
}

