/*
 * Decompiled with CFR 0.152.
 */
package views;

import forms.DistanceFormTab;
import forms.EnvironmentFormTab;
import forms.FormTabNames;
import forms.HardwareFormTab;
import forms.MiscellaneousFormTab;
import forms.ObservationFormTab;
import forms.TargetFormTab;
import gutils.ComponentMap;
import gutils.FormObserver;
import gutils.FormPanel;
import gutils.GridBag;
import gutils.JTabbedPaneStated;
import gutils.TabStateType;
import gutils.VLinkBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import models.ContextKeysMap;
import models.ContextList;
import models.ContextModel;
import views.CgdlPanel;

public class ContextPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    ComponentMap myComponentMap;
    ContextModel myContext;
    CgdlPanel myContainer;
    JTabbedPaneStated mainPanel = null;
    boolean allTabsState = true;
    int currTabIndex = 0;
    String[] formTabs = FormTabNames.stringValues();
    JPanel startTab = null;
    JPanel stopTab = null;
    JComboBox mySourceCombo;
    ArrayList<FormPanel> formsList = new ArrayList();
    final Box tabsStateBox = new Box(1);
    final JButton saveContextButton = new JButton("Save Context");
    final JTextField contextNameJTfield = new JTextField(40);
    final JLabel contextNameJLabel = new JLabel();
    static Border RADIO_BORDER = BorderFactory.createEtchedBorder(1);

    public JButton getCheckerButton(JPanel panel, ComponentMap map) {
        return new JButton("button");
    }

    public ContextPanel() {
        this(new CgdlPanel(), new ContextModel());
    }

    public ContextPanel(CgdlPanel myContainer) {
        this(myContainer, new ContextModel());
    }

    public ContextPanel(CgdlPanel myContainer, ContextModel myContext) {
        this.myContainer = myContainer;
        this.myComponentMap = new ComponentMap();
        this.setContextModel(myContext);
    }

    public void setContextModel(ContextModel extContext) {
        this.myContext = new ContextModel(extContext);
        this.myComponentMap.setValueMap(extContext.getMap());
        this.updateComponents();
    }

    public void addForm(String title, FormPanel fp) {
        ((JTabbedPaneStated)this.getPanel()).addForm(title, fp);
        this.myComponentMap.putAll(fp.getMap());
        this.formsList.add(fp);
    }

    public void checkAllForms() {
        for (FormPanel fo : this.formsList) {
            fo.checkForm();
        }
    }

    public void resetAllForms() {
        this.myComponentMap.resetValues();
    }

    public JComponent getPanel() {
        if (this.mainPanel == null) {
            this.makePanel();
        }
        return this.mainPanel;
    }

    public void makePanel() {
        this.mainPanel = new JTabbedPaneStated();
        this.startTab = this.getStartTab();
        this.stopTab = this.getStopTab();
        this.mainPanel.add("START", this.startTab, TabStateType.ELSE);
        this.addForm(FormTabNames.OBSERVATION.toString(), this.getObsTab());
        this.addForm(FormTabNames.TARGET.toString(), this.getTargetTab());
        this.addForm(FormTabNames.ENVIRONMENT.toString(), this.getEnvTab());
        this.addForm(FormTabNames.HARDWARE.toString(), this.getHardwareTab());
        this.addForm(FormTabNames.DISTANCE.toString(), this.getDistTab());
        this.addForm(FormTabNames.MISCELLANEOUS.toString(), this.getMiscTab());
        this.mainPanel.add("END", this.stopTab, TabStateType.ELSE);
        this.myComponentMap.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ContextPanel.this.mainPanel.setSelectedState(false);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.myComponentMap.addDocumentListener(new DocumentListener(){

            public void setFalseState() {
                ContextPanel.this.mainPanel.setSelectedState(false);
            }

            public void changedUpdate(DocumentEvent e) {
                this.setFalseState();
            }

            public void insertUpdate(DocumentEvent e) {
                this.setFalseState();
            }

            public void removeUpdate(DocumentEvent e) {
                this.setFalseState();
            }
        });
        this.mainPanel.addChangeListener(new TabsListener());
        this.setStartTab();
        this.updateComponents();
    }

    public void enableForms() {
        this.mainPanel.setStateAt(this.formTabs, TabStateType.UNCHECKED);
    }

    public void disableForms() {
        this.mainPanel.setStateAt(this.formTabs, TabStateType.DISABLED);
    }

    public void fixHeadingLabel(JLabel myLabel) {
        myLabel.setForeground(Color.BLUE);
        myLabel.setFont(new Font("sans", 1, 14));
    }

    public JPanel getStartTab() {
        if (this.startTab != null) {
            return this.startTab;
        }
        this.startTab = new JPanel(new GridBagLayout());
        GridBagConstraints cmnConstraints = new GridBagConstraints();
        cmnConstraints.anchor = 23;
        cmnConstraints.insets = new Insets(10, 0, 0, 10);
        cmnConstraints.fill = 2;
        GridBagConstraints[] myGrid = GridBag.GetGrid(1, 7, cmnConstraints);
        int gridIndex = 0;
        JLabel startHeading = new JLabel("START: Your context control panel.");
        this.fixHeadingLabel(startHeading);
        this.startTab.add((Component)startHeading, myGrid[gridIndex++]);
        JButton newBtn = new JButton("Create New Context");
        newBtn.setToolTipText("Clear all fields for all tabs, and begin editing a context");
        newBtn.addActionListener(new LoadNewContext());
        this.startTab.add((Component)newBtn, myGrid[gridIndex++]);
        JButton fromZipBtn = new JButton("Extract Old Context From Zip");
        fromZipBtn.setToolTipText("Get a context from and existing zip archive, and add it to our list");
        fromZipBtn.addActionListener(this.myContainer.new CgdlPanel.LoadProduct());
        fromZipBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextPanel.this.setObsTab();
            }
        });
        this.startTab.add((Component)fromZipBtn, myGrid[gridIndex++]);
        this.startTab.add((Component)this.myContainer.getChooseContextButton(), myGrid[gridIndex++]);
        this.startTab.add((Component)this.getBackHomeButton(), myGrid[gridIndex++]);
        this.startTab.add((Component)new JLabel("Temporary Context Name: "), myGrid[gridIndex++]);
        this.startTab.add((Component)this.contextNameJLabel, myGrid[gridIndex++]);
        return this.startTab;
    }

    public FormPanel getObsTab() {
        return new ObservationFormTab((FormObserver)((Object)this.getPanel()));
    }

    public FormPanel getTargetTab() {
        return new TargetFormTab((FormObserver)((Object)this.getPanel()));
    }

    public FormPanel getEnvTab() {
        return new EnvironmentFormTab((FormObserver)((Object)this.getPanel()));
    }

    public FormPanel getHardwareTab() {
        return new HardwareFormTab((FormObserver)((Object)this.getPanel()));
    }

    public FormPanel getMiscTab() {
        return new MiscellaneousFormTab((FormObserver)((Object)this.getPanel()));
    }

    public FormPanel getDistTab() {
        return new DistanceFormTab((FormObserver)((Object)this.getPanel()));
    }

    public JPanel getStopTab() {
        if (this.stopTab != null) {
            return this.stopTab;
        }
        this.stopTab = new JPanel(new GridBagLayout());
        GridBagConstraints commonConst = new GridBagConstraints();
        commonConst.anchor = 23;
        commonConst.insets = new Insets(10, 0, 0, 10);
        commonConst.fill = 2;
        GridBagConstraints[] cTable = GridBag.GetGrid(2, 5, commonConst);
        int gridIndex = 0;
        JLabel stopHeading = new JLabel("STOP: all tabs completed enables you to save current context.");
        this.fixHeadingLabel(stopHeading);
        cTable[gridIndex].gridwidth = 2;
        cTable[gridIndex].ipady = 100;
        this.stopTab.add((Component)stopHeading, cTable[gridIndex++]);
        JLabel finalNameLabel = new JLabel("Final Context Name");
        this.saveContextButton.addActionListener(new SaveContextDialog());
        this.contextNameJTfield.setEditable(false);
        int n = ++gridIndex;
        ++gridIndex;
        this.stopTab.add((Component)finalNameLabel, cTable[n]);
        int n2 = ++gridIndex;
        this.stopTab.add((Component)this.contextNameJTfield, cTable[n2]);
        int n3 = ++gridIndex;
        this.stopTab.add((Component)this.saveContextButton, cTable[n3]);
        cTable[++gridIndex].anchor = 26;
        this.stopTab.add((Component)this.tabsStateBox, cTable[gridIndex++]);
        cTable[gridIndex].anchor = 26;
        this.stopTab.add((Component)new VLinkBox(this.getCheckAllButton(), this.getBackHomeButton()), cTable[gridIndex++]);
        return this.stopTab;
    }

    public void updateComponents() {
        this.contextNameJTfield.setText(this.myContext.getName());
        this.contextNameJLabel.setText(this.myContext.getName());
        this.myContainer.MainFrame.setTitle(this.myContext.getName());
    }

    public void updateStopTab() {
        this.updateTabsStateBox();
        JTabbedPaneStated myTabPanel = this.mainPanel;
        this.saveContextButton.setEnabled(this.allTabsState);
        this.contextNameJTfield.setEnabled(this.allTabsState);
        this.updateComponents();
    }

    public void updateTabsStateBox() {
        JTabbedPaneStated myTabPanel = this.mainPanel;
        this.allTabsState = true;
        this.tabsStateBox.removeAll();
        int i = 0;
        while (i < myTabPanel.getTabCount()) {
            block5: {
                String message;
                JLabel myTabResumeLabel;
                block4: {
                    TabStateType state;
                    String title;
                    block3: {
                        title = myTabPanel.getTitleAt(i);
                        state = myTabPanel.getStateAt(i);
                        myTabResumeLabel = new JLabel();
                        if (TabStateType.CHECKED != state) break block3;
                        message = String.valueOf(title) + " is completed";
                        myTabResumeLabel.setForeground(Color.GREEN);
                        this.allTabsState &= true;
                        break block4;
                    }
                    if (TabStateType.UNCHECKED != state && TabStateType.DISABLED != state) break block5;
                    message = String.valueOf(title) + " is missing";
                    myTabResumeLabel.setForeground(Color.RED);
                    this.allTabsState &= false;
                }
                myTabResumeLabel.setText(message);
                this.tabsStateBox.add(myTabResumeLabel);
            }
            ++i;
        }
    }

    public void updateContextModel() {
        ContextKeysMap myMap = new ContextKeysMap();
        myMap.putAll(this.myComponentMap.getValueMap());
        this.myContext.setMap(myMap);
    }

    public void resetAllTabs() {
        this.mainPanel.setAllStates(false);
        this.updateStopTab();
    }

    public void setStartTab() {
        this.currTabIndex = this.mainPanel.indexOfComponent(this.startTab);
        this.mainPanel.setToolTipTextAt(this.currTabIndex, "Create or Select a Context");
        this.mainPanel.setSelectedIndex(this.currTabIndex);
    }

    public void setObsTab() {
        JTabbedPaneStated panel = (JTabbedPaneStated)this.getPanel();
        panel.setSelectedIndex(panel.indexOfTab(FormTabNames.OBSERVATION.toString()));
    }

    public JButton getCheckAllButton() {
        JButton btn = new JButton("Force Tabs to Green");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextPanel.this.checkAllForms();
            }
        });
        return btn;
    }

    public JButton getBackHomeButton() {
        JButton backHomeButton = new JButton("Back Home Page");
        backHomeButton.addActionListener(this.myContainer.new CgdlPanel.ShowWelcomePanel());
        return backHomeButton;
    }

    public void update(Observable ob, Object o) {
        this.setContextModel(((ContextList)o).getSelectedContext());
        this.checkAllForms();
        this.setObsTab();
    }

    public class LoadNewContext
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ContextPanel.this.myComponentMap.resetValues();
            ContextPanel.this.resetAllTabs();
            ContextPanel.this.setObsTab();
        }
    }

    public class SaveContextDialog
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ContextModel myContext = ContextPanel.this.myContext;
            ContextPanel.this.myContainer.saveContext(myContext);
            ContextPanel.this.resetAllTabs();
            ContextPanel.this.myContainer.showWelcomPanel();
        }
    }

    public class TabsListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            ContextPanel.this.updateContextModel();
            ContextPanel.this.updateStopTab();
        }
    }
}

