/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.WrongValueException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import models.ComponentKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContextKey implements Serializable,
ComponentKey
{
    ACQ_DATE("acq_date"),
    ACQ_HOUR("acq_hour"),
    ALBEDO("albedo"),
    ATM_COMPOSITION("atm_composition", true),
    ATM_MARS_CO2("atm_mars_co2"),
    ATM_MARS_N2("atm_mars_n2"),
    ATM_MARS_AR("atm_mars_ar"),
    ATM_OTHER("atm_other"),
    BODY_UNIT("body_unit"),
    CONTENT_DATE("content_date", "isDate", true, "today"),
    CONTENT_HOUR("content_hour", "isOk", true, "hour"),
    DISTANCE("distance", "isInt", true),
    DISTANCE_OBT("distance_obt"),
    DISTANCE_UNIT("distance_unit", true),
    ENERGY_DATA("energy_data"),
    FIBER_UNIT("fiber_unit"),
    GRANULOMETRY("granulometry"),
    GSE_CONTROL("gse_control"),
    LASER_ENERGY("laser_energy"),
    LASER_ENERGY_MEASURE("laser_energy_measure"),
    LASER_FREQUENCY("laser_frequency"),
    LASER_PULSE("laser_pulse"),
    LASER_TEMP("laser_temp"),
    LOCATION("location", "isLocation", true),
    MAST_UNIT("mast_unit"),
    MISC_COMMENTS("misc_comments"),
    OBS_PURPOSE("obs_purpose"),
    OPERATOR_NAME("operator_name"),
    ORIGIN("origin"),
    ORIGIN_OTHER("origin_other"),
    PRESSURE("pressure"),
    PRESSURE_CTRL("pressure_ctrl"),
    ROUGHNESS("roughness"),
    SOH_FILE("soh_file"),
    SOURCE("source", true),
    TARGET_COMPOSITION("target_composition"),
    TARGET_NAME("target_name", "isFilled", true),
    TARGET_SIZE("target_size", "isSize");

    private final String name;
    private String validator;
    private String errMessage;
    private Boolean isMandatory = false;
    private String defaulter;

    private ContextKey(String name) {
        this(name, "isOk");
    }

    private ContextKey(String name, String validator) {
        this.name = name;
        this.validator = validator;
    }

    private ContextKey(String name, String validator, Boolean isMandatory) {
        this(name, validator);
        this.isMandatory = isMandatory;
    }

    private ContextKey(String name, String validator, Boolean isMandatory, String defaulter) {
        this(name, validator, isMandatory);
        this.defaulter = defaulter;
    }

    private ContextKey(String name, Boolean isMandatory) {
        this(name);
        this.isMandatory = isMandatory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object string2method(String stringMethod, Object value) {
        Class<?> me = this.getClass();
        Object methodResult = null;
        try {
            Method myMethod = me.getDeclaredMethod(stringMethod, Object.class);
            methodResult = myMethod.invoke((Object)this, value);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return methodResult;
    }

    @Override
    public boolean isValid(Object value) throws WrongValueException {
        Object myReturn = this.string2method(this.validator, value);
        if (myReturn.equals(false)) {
            this.errMessage = "Wrong value >>" + (String)value + "<< for field " + this.toString();
        }
        return myReturn.equals(true);
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public String getDefaultValue() {
        String defaultValue = this.defaulter == null ? null : (String)this.string2method(this.defaulter, null);
        return defaultValue;
    }

    @Override
    public String getErrMessage() {
        return this.errMessage;
    }

    public String toString() {
        return this.name();
    }

    private boolean isSize(Object argvalue) {
        return true;
    }

    private boolean isFilled(Object argvalue) {
        int length = ((String)argvalue).length();
        return length > 0;
    }

    private boolean isDate(Object argvalue) {
        String strDate = (String)argvalue;
        int lgthDate = strDate.length();
        return this.isInt(strDate) && lgthDate == 8;
    }

    private boolean isOk(Object argvalue) {
        return true;
    }

    private boolean isLocation(Object argvalue) {
        int index = ((String)argvalue).indexOf("choose");
        return index == -1;
    }

    private boolean isInt(Object argvalue) {
        boolean isInt = true;
        try {
            int myInt = Integer.parseInt((String)argvalue);
        }
        catch (NumberFormatException e) {
            isInt = false;
        }
        return isInt;
    }

    public String today(Object value) {
        return String.format("%tY%<tm%<td", new Date());
    }

    public String hour(Object value) {
        return String.format("%tH", new Date());
    }
}

