/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.WrongAttachmentAttribute;
import futils.XmlUtils;
import java.io.File;
import java.util.Random;
import junit.framework.TestCase;
import models.AttachmentData;
import models.AttachmentList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class AttachmentListTest
extends TestCase {
    private static File TEST_DATA_DIR = new File("test-datas");
    public AttachmentList myAL = new AttachmentList();
    public File metaDataFile = new File(TEST_DATA_DIR, "AttachmentList.xml");
    public File baseDataDir = new File(TEST_DATA_DIR, "attachementDatas");
    public int numFiles = 4;

    public AttachmentListTest(String name) throws WrongAttachmentAttribute {
        super(name);
        this.myAL.loadXML(this.baseDataDir, this.metaDataFile);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRemoveFile() {
        this.myAL.removeFile("quatre.txt");
        AttachmentListTest.assertEquals(this.numFiles - 1, this.myAL.getFiles().length);
    }

    public void testAddFile() {
        this.myAL.addFile(new File(TEST_DATA_DIR, "logoCnes.gif"));
        AttachmentListTest.assertEquals(this.numFiles + 1, this.myAL.size());
    }

    public void testAddFiles() {
        File anotherDir = new File(TEST_DATA_DIR, "productDirToLoad" + File.separator + "FOCUS_20090529_Craie_Normande__Earth_CESR___3265mm_000");
        File[] files = anotherDir.listFiles();
        this.myAL.addFiles(files);
        AttachmentListTest.assertEquals(this.numFiles + files.length - 1, this.myAL.size());
    }

    public void testHasFile() {
        AttachmentListTest.assertTrue(this.myAL.hasFile("un.txt"));
    }

    public void testToXML() {
        String xmlStr = XmlUtils.saveXML(this.myAL.toXML());
        AttachmentListTest.assertTrue(xmlStr.indexOf("<numericals>") > -1);
    }

    public void testToXmlTwice() {
        try {
            this.myAL.toXML();
            this.myAL.toXML();
        }
        catch (DOMException e) {
            e.printStackTrace();
            AttachmentListTest.fail("shouldnt raise exception");
        }
        AttachmentListTest.assertTrue(true);
    }

    public void testToXmlEmpty() {
        AttachmentList anAttachL = new AttachmentList();
        AttachmentListTest.assertNotNull(anAttachL.toXML().getDocumentElement());
    }

    public void testLoadXML() {
        AttachmentList theAL = new AttachmentList();
        try {
            theAL.loadXML(this.baseDataDir, this.metaDataFile);
        }
        catch (WrongAttachmentAttribute e) {
            e.printStackTrace();
            AttachmentListTest.fail(e.getMessage());
        }
        AttachmentListTest.assertEquals(this.numFiles, this.myAL.size());
    }

    public void testGetFiles() {
        AttachmentListTest.assertEquals(this.numFiles, this.myAL.size());
    }

    public void testRemoveAttachment() {
        AttachmentData[] attachments = this.myAL.getAttachments();
        int index = new Random().nextInt(attachments.length);
        this.myAL.removeAttachment(attachments[index]);
        AttachmentListTest.assertEquals(this.numFiles - 1, this.myAL.size());
    }

    public void testGetDom() {
        Document dom1 = this.myAL.getDom();
        Document dom2 = this.myAL.getDom();
        AttachmentListTest.assertEquals(dom1, dom2);
    }

    public void testAddFilesToXML() {
        Document theDom = this.myAL.toXML();
        int num = this.myAL.getFiles().length;
        int numNumericals = theDom.getElementsByTagName("numerical").getLength();
        int i = 0;
        while (i < 25) {
            theDom = this.myAL.toXML();
            ++i;
        }
        int newNum = this.myAL.getFiles().length;
        int newNumNumericals = theDom.getElementsByTagName("numerical").getLength();
        AttachmentListTest.assertEquals(num, newNum);
        AttachmentListTest.assertEquals(numNumericals, newNumNumericals);
    }
}

