/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.WrongAttachmentAttribute;
import futils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import models.AttachmentData;
import models.AttachmentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentList
extends AbstractTableModel {
    static final int TYPE_COLUMN = 2;
    static final int LINK_COLUMN = 3;
    static final String[] colNames = new String[]{"num", "File Name", "Type", "Link"};
    static int count = 0;
    private Document myDom = null;
    private ArrayList<AttachmentData> attachments = new ArrayList();

    public void removeFile(String fileName) {
        for (AttachmentData attachmentData : this.attachments) {
            String currentName = attachmentData.getFile().getName();
            if (!currentName.equals(fileName)) continue;
            this.removeAttachment(attachmentData);
            break;
        }
    }

    public void removeFile(File attachmentFile) {
        this.removeFile(attachmentFile.getName());
    }

    public void removeAttachment(AttachmentData attachment) {
        this.attachments.remove(this.attachments.indexOf(attachment));
    }

    public void addFile(File file) {
        this.attachments.add(new AttachmentData(file));
        this.fireTableDataChanged();
    }

    public void addFiles(File[] filesList, AttachmentType type) {
    }

    public void addFiles(File[] filesList) {
        File[] fileArray = filesList;
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && !this.hasFile(file.getName())) {
                this.addFile(file);
            }
            ++n2;
        }
    }

    public boolean hasFile(String fileName) {
        boolean result = false;
        File[] fileArray = this.getFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (fileName.equals(file.getName())) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public void loadXML(File attachmentsDir, File metaData) throws WrongAttachmentAttribute {
        Document theDom = XmlUtils.readXML(metaData);
        Element numericalsNode = (Element)theDom.getElementsByTagName("numericals").item(0);
        NodeList numericalsList = numericalsNode.getElementsByTagName("numerical");
        this.attachments.clear();
        int i = 0;
        while (i < numericalsList.getLength()) {
            this.attachments.add(new AttachmentData((Element)numericalsList.item(i), attachmentsDir));
            ++i;
        }
    }

    public Document getDom() {
        if (this.myDom == null) {
            this.myDom = XmlUtils.GetDocument();
            this.myDom.appendChild(this.getRootNode());
        }
        return this.myDom;
    }

    public Element getRootNode() {
        Element rootNode = this.getDom().createElement("numericals");
        return rootNode;
    }

    public Document toXML() {
        Element rootNode = this.getRootNode();
        Document theDom = this.getDom();
        for (AttachmentData attachment : this.attachments) {
            rootNode.appendChild(theDom.importNode(attachment.toNode(), true));
        }
        theDom.replaceChild(rootNode, theDom.getDocumentElement());
        return theDom;
    }

    public File[] getFiles() {
        ArrayList<File> theList = new ArrayList<File>();
        for (AttachmentData data : this.attachments) {
            theList.add(data.getFile());
        }
        return theList.toArray(new File[theList.size()]);
    }

    public AttachmentData[] getAttachments() {
        return this.attachments.toArray(new AttachmentData[this.attachments.size()]);
    }

    public void clear() {
        this.attachments.clear();
    }

    public int size() {
        return this.attachments.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        System.out.println(columnIndex);
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return colNames[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.attachments.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttachmentData theAttach = this.attachments.get(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = rowIndex;
                break;
            }
            case 1: {
                value = theAttach.getFile().getName();
                break;
            }
            case 2: {
                value = theAttach.getType().toString();
                break;
            }
            case 3: {
                value = theAttach.getLink();
            }
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2 || columnIndex == 3;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AttachmentData theAttach = this.attachments.get(rowIndex);
        if (2 == columnIndex) {
            try {
                theAttach.setType((String)aValue);
            }
            catch (WrongAttachmentAttribute e) {
                e.printStackTrace();
            }
        } else if (3 == columnIndex) {
            System.out.println((String)aValue);
            theAttach.setLink((String)aValue);
        }
        this.fireTableDataChanged();
    }

    public void removeRows(int[] rowIndexes) {
        Arrays.sort(rowIndexes);
        int i = rowIndexes.length - 1;
        while (i >= 0) {
            this.attachments.remove(rowIndexes[i]);
            --i;
        }
        this.fireTableDataChanged();
    }
}

