/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.WrongAttachmentAttribute;
import futils.XmlUtils;
import java.io.File;
import junit.framework.TestCase;
import models.AttachmentData;
import models.AttachmentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AttachmentDataTest
extends TestCase {
    AttachmentData myAD;
    File dataFile = new File("test-datas" + File.separator + "logoCnes.gif");
    Document attachmentDom = XmlUtils.readXML(new File("test-datas" + File.separator + "AttachmentNode.xml"));
    Document oldSepDom = XmlUtils.readXML(new File("test-datas" + File.separator + "AttachmentNodeOldSep.xml"));

    public AttachmentDataTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myAD = new AttachmentData(this.dataFile, "My Test Comment", AttachmentType.OTHER);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetFile() {
        AttachmentDataTest.assertTrue(this.myAD.getFile().exists());
    }

    public void testToNode() {
        AttachmentDataTest.assertEquals(5, this.myAD.toNode().getChildNodes().getLength());
    }

    public void testLoadNode() {
        try {
            Element doc = this.attachmentDom.getDocumentElement();
            this.myAD.loadNode(doc);
        }
        catch (WrongAttachmentAttribute e) {
            e.printStackTrace();
            AttachmentDataTest.fail(e.getMessage());
        }
    }
}

