/*
 * Decompiled with CFR 0.152.
 */
package futils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileCopy {
    public static final void CopyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static final void CopyInputFile(File inputFile, File outputFile) throws FileNotFoundException, IOException {
        Object in = null;
        Object out = null;
        FileCopy.CopyInputStream(new FileInputStream(inputFile), new FileOutputStream(outputFile));
    }

    public static final void MoveInputFile(File inputFile, File outputFile) throws FileNotFoundException, IOException {
        FileCopy.CopyInputFile(inputFile, outputFile);
        inputFile.delete();
    }

    public static final void RecurseDelete(File dirOrFile) {
        if (dirOrFile == null) {
            return;
        }
        if (dirOrFile.isDirectory() && dirOrFile.list().length > 0) {
            File[] fileArray = dirOrFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                FileCopy.RecurseDelete(childFile);
                ++n2;
            }
        }
        dirOrFile.delete();
    }

    public static final File[] RecurseTree(File dirFile) {
        if (dirFile.isFile()) {
            return new File[]{dirFile};
        }
        ArrayList<File> resultList = new ArrayList<File>();
        File[] fileArray = dirFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File[] fileArray2 = FileCopy.RecurseTree(file);
            int n3 = fileArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                File child = fileArray2[n4];
                resultList.add(child);
                ++n4;
            }
            ++n2;
        }
        return resultList.toArray(new File[resultList.size()]);
    }

    public static final void RecurseCopy(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("copyFiles: Can not find source: " + src.getAbsolutePath() + ".");
        }
        if (!src.canRead()) {
            throw new IOException("copyFiles: No right to source: " + src.getAbsolutePath() + ".");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("copyFiles: Could not create direcotry: " + dest.getAbsolutePath() + ".");
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                FileCopy.RecurseCopy(src1, dest1);
                ++i;
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int bytesRead;
                    fin = new FileInputStream(src);
                    fout = new FileOutputStream(dest);
                    while ((bytesRead = fin.read(buffer)) >= 0) {
                        fout.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    IOException wrapper = new IOException("copyFiles: Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath() + ".");
                    wrapper.initCause(e);
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
    }
}

