/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import models.ContextKeysMap;
import models.ContextList;
import models.ContextModel;
import models.FinalProduct;
import views.ContextListPanel;
import views.ContextPanel;
import views.LinkPanel;
import views.WelcomePanel;

public class CgdlPanel {
    int chooserRes;
    ContextList myContextList = new ContextList();
    ContextModel myContext = new ContextModel();
    FinalProduct myProduct = new FinalProduct(this.myContext);
    JFrame MainFrame = new JFrame();
    JPanel MainPanel = new JPanel(new BorderLayout());
    JPanel CardsPanel = new JPanel(new CardLayout());
    ContextPanel myContextPanel;
    LinkPanel myLinkPanel;
    private ContextListPanel contextListPanel;
    static final String CONTEXTLABEL = "ContextModel Editor";
    static final String DATALINKLABEL = "Data Linker";
    static final String WELCOMELABEL = "Welcome to ChemCam Lab Tool";

    public CgdlPanel() {
        this.myContext.setName("no-name");
        this.myLinkPanel = new LinkPanel(this, this.myProduct);
        this.myContextPanel = new ContextPanel(this);
        this.myContextList.load();
        this.myContextList.addObserver(this.myContextPanel);
        this.myContextList.addObserver(this.myLinkPanel);
        this.myProduct.addListener(this.myLinkPanel);
    }

    public void makeIhm() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem fileQuitItem = new JMenuItem("Quit");
        fileQuitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(fileQuitItem);
        menuBar.add(fileMenu);
        JMenu contextMenu = new JMenu("ContextModel");
        JMenuItem contextNewItem = new JMenuItem("New");
        JMenuItem contextOpenItem = new JMenuItem("Open");
        JMenuItem contextImportItem = new JMenuItem("Import");
        contextNewItem.addActionListener(new ShowContextPanel());
        contextOpenItem.addActionListener(new NotImplementedYet());
        contextImportItem.addActionListener(new NotImplementedYet());
        contextMenu.add(contextNewItem);
        contextMenu.add(contextOpenItem);
        contextMenu.add(contextImportItem);
        JMenu toolsMenu = new JMenu("Tools");
        JMenuItem toolsPreferences = new JMenuItem("Preferences");
        toolsPreferences.addActionListener(new NotImplementedYet());
        toolsMenu.add(toolsPreferences);
        JMenu panelsMenu = new JMenu("Panels");
        JMenuItem panelsWelcome = new JMenuItem("Welcome");
        JMenuItem panelsContext = new JMenuItem("ContextModel");
        JMenuItem panelsLink = new JMenuItem("Link");
        panelsWelcome.addActionListener(new ShowWelcomePanel());
        panelsContext.addActionListener(new ShowContextPanel());
        panelsLink.addActionListener(new ShowLinkPanel());
        panelsMenu.add(panelsWelcome);
        panelsMenu.add(panelsContext);
        panelsMenu.add(panelsLink);
        menuBar.add(panelsMenu);
        this.MainFrame.setJMenuBar(menuBar);
        this.addCard(this.getWelcomePanel(), WELCOMELABEL);
        this.addCard(this.myContextPanel.getPanel(), CONTEXTLABEL);
        this.addCard(this.myLinkPanel.getPanel(), DATALINKLABEL);
        this.MainPanel.add((Component)this.CardsPanel, "Center");
        this.MainFrame.setContentPane(this.MainPanel);
        this.MainFrame.setDefaultCloseOperation(3);
        this.MainFrame.setSize(850, 650);
        this.MainFrame.setVisible(true);
    }

    public void addCard(JComponent aPanel, String aLabel) {
        this.CardsPanel.add((Component)new JScrollPane(aPanel), aLabel);
    }

    public JPanel getWelcomePanel() {
        WelcomePanel wPanel = new WelcomePanel();
        wPanel.getContextButton().addActionListener(new ShowContextPanel());
        wPanel.getLinkButton().addActionListener(new ShowLinkPanel());
        return wPanel;
    }

    public boolean saveContext(ContextModel theContext) {
        int choice;
        if (!this.myContextList.isAvailable(theContext.getName()).booleanValue() && 1 == (choice = JOptionPane.showConfirmDialog(null, "Context Changed\nDo you want to Overwrite ?", theContext.getName(), 0))) {
            theContext.resetIncrement();
            do {
                theContext.nextName();
            } while (!this.myContextList.isAvailable(theContext.getName()).booleanValue());
        }
        this.myContextList.addContext(theContext);
        return true;
    }

    public void loadProduct(File file) {
        try {
            this.myProduct.loadZip(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ContextModel cm = this.myProduct.getContext();
        this.saveContext(cm);
    }

    public void notifyProductChanged(ContextKeysMap myMap) {
        this.myProduct.setContextMap(myMap);
    }

    public JComboBox getContextListCombo() {
        JComboBox<String> contextListCombo = new JComboBox<String>(this.myContextList.getNamesList());
        return contextListCombo;
    }

    public JFrame getContextListPanel() {
        if (this.contextListPanel == null) {
            this.contextListPanel = new ContextListPanel(this.myContextList);
        }
        return this.contextListPanel;
    }

    public JButton getChooseContextButton() {
        JButton chooseCtxBtn = new JButton("Choose Old Context From List");
        chooseCtxBtn.setToolTipText("Open your list manager to choose or delete contexts");
        chooseCtxBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CgdlPanel.this.getContextListPanel().show();
            }
        });
        return chooseCtxBtn;
    }

    public void showWelcomPanel() {
        ((CardLayout)this.CardsPanel.getLayout()).show(this.CardsPanel, WELCOMELABEL);
    }

    public class LoadProduct
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int chooserRes;
            JFileChooser productChooser = new JFileChooser();
            String archiveDirName = System.getProperty("user.archiveDir");
            if (archiveDirName != null) {
                productChooser.setCurrentDirectory(new File(archiveDirName));
            }
            if ((chooserRes = productChooser.showOpenDialog(CgdlPanel.this.MainPanel)) == 1) {
                return;
            }
            try {
                System.setProperty("user.archiveDir", productChooser.getCurrentDirectory().getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            CgdlPanel.this.loadProduct(productChooser.getSelectedFile());
        }
    }

    public class NotImplementedYet
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(CgdlPanel.this.MainFrame, "Not Implemented Yet");
        }
    }

    public class SetContextValid
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class SetLinkValid
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class SetMakeValid
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class ShowContextChooser
    implements ActionListener {
        public void actionPerformed(ActionEvent arg0) {
            CgdlPanel.this.getContextListPanel().show();
        }
    }

    public class ShowContextPanel
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ContextPanel ourCPanel = CgdlPanel.this.myContextPanel;
            ourCPanel.setContextModel(CgdlPanel.this.myContext);
            ourCPanel.resetAllTabs();
            ourCPanel.setStartTab();
            ((CardLayout)CgdlPanel.this.CardsPanel.getLayout()).show(CgdlPanel.this.CardsPanel, CgdlPanel.CONTEXTLABEL);
        }
    }

    public class ShowLinkPanel
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ((CardLayout)CgdlPanel.this.CardsPanel.getLayout()).show(CgdlPanel.this.CardsPanel, CgdlPanel.DATALINKLABEL);
        }
    }

    public class ShowWelcomePanel
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            CgdlPanel.this.showWelcomPanel();
        }
    }
}

