/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.ArchiveException;
import exceptions.WrongAttachmentAttribute;
import exceptions.WrongProductFileException;
import futils.FileCopy;
import futils.XmlUtils;
import futils.ZipArchive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipException;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import models.AttachmentData;
import models.AttachmentList;
import models.AttachmentType;
import models.ContextModel;
import mvc.FinalListener;
import mvc.ListenableProductModel;
import mvc.ProductChangedEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FinalProduct
implements ListenableProductModel,
TableModelListener {
    private EventListenerList listeners;
    private AttachmentList myAttachmentList;
    private ContextModel myContext;
    private Document myDom;
    private String name;
    private File diskModel;
    private File extractDir = null;

    private FinalProduct() {
        this.myDom = XmlUtils.GetDocument();
        this.myDom.appendChild(this.getRootNode());
        this.listeners = new EventListenerList();
        this.setName("defaultProductName");
        this.myAttachmentList = new AttachmentList();
        this.myAttachmentList.addTableModelListener(this);
    }

    public FinalProduct(ContextModel aContext) {
        this();
        this.setContext(aContext);
    }

    public FinalProduct(ContextModel myContext, File[] numericalDatas) {
    }

    public Element getRootNode() {
        Element rootElement = this.myDom.createElement("CgdlProduct");
        rootElement.setAttribute("version", "0.4.1");
        return rootElement;
    }

    public void setContextMap(Map map) {
        this.myContext.setMap(map);
        this.setContext(this.myContext);
    }

    public void setContext(ContextModel aContext) {
        this.myContext = aContext;
        this.setName(aContext.getName());
        this.fireModelChanged();
    }

    public ContextModel getContext() {
        return this.myContext;
    }

    public void setFile(File file) {
        this.diskModel = file;
    }

    public void setFileName(String filename) {
        this.setFile(new File(filename));
    }

    public File getFile() {
        return this.diskModel;
    }

    public String getFileName() {
        return this.diskModel.getName();
    }

    public void setName(String name) {
        this.name = name;
        this.setFileName(String.valueOf(name) + ".zip");
    }

    public String getName() {
        return this.name;
    }

    public AttachmentList getAttachmentsList() {
        return this.myAttachmentList;
    }

    public File toZip() throws ArchiveException, WrongProductFileException {
        ZipArchive myArchive = new ZipArchive(this.getFile());
        File fsDir = this.toFS();
        myArchive.addDirContents(fsDir);
        File result = myArchive.write();
        FileCopy.RecurseDelete(fsDir);
        this.setFile(result);
        this.fireModelChanged();
        return result;
    }

    public File toZip(File outfile) throws ArchiveException, WrongProductFileException {
        this.setFile(outfile);
        return this.toZip();
    }

    public File toFS() throws WrongProductFileException {
        String productName = this.getName();
        String productDirName = String.valueOf(productName) + "FS";
        File productFsDir = new File(System.getProperty("user.tempDir"), productDirName);
        int i = 0;
        while (productFsDir.isDirectory()) {
            String dirName = String.valueOf(productDirName) + "_" + Integer.toString(i);
            productFsDir = new File(System.getProperty("user.tempDir"), dirName);
            ++i;
        }
        if (!productFsDir.mkdir()) {
            throw new WrongProductFileException("couldnt create dir " + productFsDir.getAbsolutePath());
        }
        File productDataDir = new File(productFsDir, productName);
        if (productDataDir.isDirectory()) {
            FileCopy.RecurseDelete(productDataDir);
        }
        if (!productDataDir.mkdir()) {
            throw new WrongProductFileException("couldnt create dir " + productDataDir.getAbsolutePath());
        }
        AttachmentData[] attachmentDataArray = this.myAttachmentList.getAttachments();
        int n = attachmentDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttachmentData attachment = attachmentDataArray[n2];
            File origFile = attachment.getFile();
            File destFile = new File(productDataDir, origFile.getName());
            try {
                FileCopy.CopyInputFile(origFile, destFile);
                attachment.setFile(destFile);
            }
            catch (FileNotFoundException e) {
                throw new WrongProductFileException("No Such File to attach: " + origFile.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        File xmlView = this.saveXML();
        try {
            FileCopy.MoveInputFile(xmlView, new File(productFsDir + File.separator + xmlView.getName()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return productFsDir;
    }

    public void loadFS(File productDir) throws WrongProductFileException, IOException, WrongAttachmentAttribute {
        File metaFile = null;
        File dataDir = null;
        ArrayList myNumericals = new ArrayList();
        if (!productDir.isDirectory()) {
            throw new WrongProductFileException(String.valueOf(productDir.getName()) + " should be a valid directory");
        }
        File[] fileArray = productDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isDirectory()) {
                dataDir = file;
            } else if (file.isFile() && fileName.indexOf("xml") > 0) {
                metaFile = file;
            } else {
                throw new WrongProductFileException(String.valueOf(file.getPath()) + " shouldnt belong to archive " + this.getName());
            }
            ++n2;
        }
        this.myAttachmentList.loadXML(dataDir, metaFile);
        this.myContext.loadXML(metaFile);
        this.setContext(this.myContext);
    }

    public Document getMetaXml() {
        Element newRootNode = this.getRootNode();
        newRootNode.appendChild(this.myDom.importNode(this.myContext.toXML().getDocumentElement(), true));
        newRootNode.appendChild(this.myDom.importNode(this.myAttachmentList.toXML().getDocumentElement(), true));
        this.myDom.replaceChild(newRootNode, this.myDom.getDocumentElement());
        return this.myDom;
    }

    public void loadZip(File zipfile) throws WrongProductFileException, ZipException, IOException, WrongAttachmentAttribute {
        ZipArchive theArch = new ZipArchive(zipfile);
        File destDir = null;
        destDir = theArch.extractTo(this.getExtractDir());
        this.loadFS(destDir);
    }

    public void loadZip(String zipfileName) throws WrongProductFileException, ZipException, IOException, WrongAttachmentAttribute {
        this.loadZip(new File(zipfileName));
    }

    public File getExtractDir() {
        this.extractDir = new File(System.getProperty("user.tempDir"), "extractDir");
        if (this.extractDir.isDirectory()) {
            FileCopy.RecurseDelete(this.extractDir);
        } else if (this.extractDir.isFile()) {
            this.extractDir.delete();
        }
        this.extractDir.mkdir();
        return this.extractDir;
    }

    public File saveXML() {
        return XmlUtils.saveXML(this.getMetaXml(), String.valueOf(this.getName()) + ".xml");
    }

    public String toString() {
        return XmlUtils.saveXML(this.getMetaXml());
    }

    public void removeNumerical(File numerical) {
        this.myAttachmentList.removeFile(numerical);
        this.fireModelChanged();
    }

    public void removeAttachment(AttachmentData attachment) {
        this.myAttachmentList.removeAttachment(attachment);
        this.fireModelChanged();
    }

    public void clearAttachments() {
        this.myAttachmentList.clear();
        this.fireModelChanged();
    }

    public void addNumericals(File[] numericalDatas) {
        this.myAttachmentList.addFiles(numericalDatas);
    }

    public void addNumericals(File[] numericalDatas, AttachmentType type) {
        this.myAttachmentList.addFiles(numericalDatas, type);
    }

    public File[] getNumericals() {
        return this.myAttachmentList.getFiles();
    }

    public boolean hasListener(FinalListener l) {
        FinalListener[] listenersList = this.getListeners();
        if (listenersList == null || l == null) {
            return false;
        }
        FinalListener[] finalListenerArray = listenersList;
        int n = listenersList.length;
        int n2 = 0;
        while (n2 < n) {
            FinalListener m = finalListenerArray[n2];
            if (l.equals(m)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addListener(FinalListener l) {
        if (!this.hasListener(l)) {
            this.listeners.add(FinalListener.class, l);
        }
    }

    public void fireModelChanged() {
        FinalListener[] lList;
        FinalListener[] finalListenerArray = lList = this.getListeners();
        int n = lList.length;
        int n2 = 0;
        while (n2 < n) {
            FinalListener l = finalListenerArray[n2];
            l.finalChanged(new ProductChangedEvent(this));
            ++n2;
        }
    }

    public FinalListener[] getListeners() {
        if (this.listeners == null) {
            return null;
        }
        return (FinalListener[])this.listeners.getListeners(FinalListener.class);
    }

    protected void finalize() {
        FileCopy.RecurseDelete(this.getExtractDir());
    }

    public void tableChanged(TableModelEvent e) {
        this.fireModelChanged();
    }
}

