/*
 * Decompiled with CFR 0.152.
 */
package gutils;

import exceptions.WrongValueException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import models.ComponentKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMap<KeyType extends ComponentKey> {
    private HashMap<KeyType, Object> myComponentKeyMap = new HashMap();

    public ComponentMap() {
        this(new HashMap());
    }

    public ComponentMap(Map<KeyType, Object> aKeyMap) {
        this.setValueMap(aKeyMap);
    }

    public void setComponentValue(KeyType key, String value) {
        Object myComp = this.myComponentKeyMap.get(key);
        if (myComp instanceof JTextComponent) {
            ((JTextComponent)myComp).setText(value);
        } else if (myComp instanceof JLabel) {
            ((JLabel)myComp).setText(value);
        } else if (myComp instanceof JComboBox) {
            if (value == null) {
                ((JComboBox)myComp).setSelectedIndex(0);
            } else {
                ((JComboBox)myComp).setSelectedItem(value);
            }
        } else if (myComp instanceof ButtonGroup) {
            ButtonGroup myGroup = (ButtonGroup)myComp;
            Enumeration<AbstractButton> e = myGroup.getElements();
            while (e.hasMoreElements()) {
                JRadioButton btn = (JRadioButton)e.nextElement();
                String actionCmd = btn.getActionCommand();
                if (!actionCmd.equals(value)) continue;
                myGroup.setSelected(btn.getModel(), true);
                break;
            }
        } else if (myComp == null) {
            System.err.println(key + " not available");
        } else {
            System.err.println("What is that class:" + myComp.getClass());
        }
    }

    public String getComponentValue(KeyType key) {
        String resString = null;
        Object myComp = this.myComponentKeyMap.get(key);
        if (myComp == null) {
            resString = "no such key <" + key + ">";
        } else if (myComp instanceof JTextComponent) {
            resString = ((JTextComponent)myComp).getText();
        } else if (myComp instanceof JLabel) {
            resString = ((JLabel)myComp).getText();
        } else if (myComp instanceof JComboBox) {
            resString = (String)((JComboBox)myComp).getSelectedItem();
        } else if (myComp instanceof ButtonGroup) {
            ButtonModel btn = ((ButtonGroup)myComp).getSelection();
            resString = btn == null ? "none selected" : btn.getActionCommand();
        } else {
            System.err.println("Component not found" + myComp.getClass());
        }
        return resString;
    }

    public void resetComponentValue(KeyType key) {
        this.setComponentValue(key, key.getDefaultValue());
    }

    public HashMap<KeyType, Object> getValueMap() {
        HashMap<ComponentKey, String> resMap = new HashMap<ComponentKey, String>();
        for (ComponentKey key : this.myComponentKeyMap.keySet()) {
            resMap.put(key, this.getComponentValue(key));
        }
        return resMap;
    }

    public Object[] getComponents() {
        return this.myComponentKeyMap.values().toArray();
    }

    public Object[] getKeys() {
        return this.myComponentKeyMap.keySet().toArray();
    }

    public void setValueMap(Map<KeyType, Object> valueMap) {
        for (ComponentKey key : valueMap.keySet()) {
            String value = (String)valueMap.get(key);
            this.setComponentValue(key, value);
        }
    }

    public boolean checkComponents(KeyType[] componentKeys) throws WrongValueException {
        boolean res = true;
        String errMsg = "";
        KeyType[] KeyTypeArray = componentKeys;
        int n = componentKeys.length;
        int n2 = 0;
        while (n2 < n) {
            KeyType key = KeyTypeArray[n2];
            boolean isValid = key.isValid(this.getComponentValue(key));
            if (!isValid) {
                errMsg = String.valueOf(errMsg) + "\n" + key.getErrMessage();
            }
            res &= isValid;
            ++n2;
        }
        if (!res) {
            throw new WrongValueException(errMsg);
        }
        return res;
    }

    public boolean checkComponents() throws WrongValueException {
        boolean res = true;
        String errMsg = "";
        for (ComponentKey key : this.myComponentKeyMap.keySet()) {
            boolean isValid = key.isValid(this.getComponentValue(key));
            if (!isValid) {
                errMsg = String.valueOf(errMsg) + "\n" + key.getErrMessage();
            }
            res &= isValid;
        }
        if (!res) {
            throw new WrongValueException(errMsg);
        }
        return res;
    }

    public void put(KeyType key, Object value) {
        if (value instanceof ButtonGroup) {
            ButtonGroup myGroup = (ButtonGroup)value;
            Enumeration<AbstractButton> e = myGroup.getElements();
            while (e.hasMoreElements()) {
                JRadioButton btn = (JRadioButton)e.nextElement();
                btn.setActionCommand(btn.getText());
            }
        }
        if (value instanceof Component && key.isMandatory()) {
            ((Component)value).setBackground(Color.CYAN);
        }
        this.myComponentKeyMap.put(key, value);
    }

    public void putAll(ComponentMap map) {
        this.myComponentKeyMap.putAll(map.getComponentKeyMap());
    }

    public HashMap<KeyType, Object> getComponentKeyMap() {
        return this.myComponentKeyMap;
    }

    public int size() {
        return this.myComponentKeyMap.size();
    }

    public void resetValues() {
        HashMap valueMap = new HashMap();
        for (ComponentKey key : this.myComponentKeyMap.keySet()) {
            this.resetComponentValue(key);
        }
    }

    public void addDocumentListener(DocumentListener l) {
        Object[] objectArray = this.getComponents();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object aJTComp = objectArray[n2];
            try {
                ((JTextComponent)aJTComp).getDocument().addDocumentListener(l);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void addFocusListener(FocusListener l) {
        Object[] objectArray = this.getComponents();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object aJComp = objectArray[n2];
            try {
                ((Component)aJComp).addFocusListener(l);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n2;
        }
    }
}

