/*
 * Decompiled with CFR 0.152.
 */
package models;

import futils.XmlUtils;
import java.io.File;
import junit.framework.TestCase;
import models.ContextList;
import models.ContextModel;
import org.w3c.dom.Document;

public class ContextListTest
extends TestCase {
    static final String CONTEXT_NAME = "My_Name";
    private ContextList myContextList;
    private ContextModel myContextModel;
    private String[] names = new String[]{"a", "b", "c"};
    private File baseDir = new File("test-datas");
    private String[] contextFiles = new String[]{"Context1.xml", "Context2.xml", "Context3.xml"};
    private File theContextFile = new File(this.baseDir, "CgdlContextList.xml");

    public ContextListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myContextList = new ContextList();
        this.myContextModel = new ContextModel(CONTEXT_NAME);
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.myContextList.addContext(new ContextModel(name));
            ++n2;
        }
        stringArray = this.contextFiles;
        n = this.contextFiles.length;
        n2 = 0;
        while (n2 < n) {
            String cFile = stringArray[n2];
            ContextModel context = new ContextModel();
            context.loadXML(new File(this.baseDir, cFile));
            this.myContextList.addContext(context);
            ++n2;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConstructorFile() {
        this.myContextList = new ContextList(this.theContextFile);
        ContextListTest.assertEquals(6, this.myContextList.getSize());
        ContextListTest.assertEquals(6, this.myContextList.getNamesList().length);
    }

    public void testAddContext() {
        this.myContextList.addContext(this.myContextModel);
        ContextListTest.assertTrue(this.myContextList.hasContext(this.myContextModel));
    }

    public void testGetContext() {
        this.myContextList.addContext(this.myContextModel);
        String contextName = this.myContextModel.getName();
        ContextModel theModel = this.myContextList.getContext(contextName);
        ContextListTest.assertEquals(contextName, theModel.getName());
    }

    public void testGetContext2() {
        ContextModel newModel = new ContextModel("newname");
        this.myContextList.addContext(newModel);
        String newName = newModel.getName();
        ContextModel theModel = this.myContextList.getContext(newName);
        ContextListTest.assertEquals(newName, theModel.getName());
    }

    public void testGetNamesList() {
        String[] snd;
        String[] stringArray = snd = this.myContextList.getNamesList();
        int n = snd.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            System.out.println("---> " + name);
            ContextListTest.assertEquals(this.myContextList.getContext(name).getName(), name);
            ++n2;
        }
    }

    public void testSave() {
        ContextListTest.assertTrue(this.myContextList.save().exists());
    }

    public void testDeleteContext() {
        int numNames = this.myContextList.getNamesList().length;
        String firstName = this.myContextList.getNamesList()[0];
        this.myContextList.deleteContext(firstName);
        ContextListTest.assertEquals(--numNames, this.myContextList.getNamesList().length);
    }

    public void testDeleteAll() {
        ContextListTest.assertTrue(this.myContextList.getNamesList().length > 0);
        this.myContextList.deleteAll();
        Document theDom = XmlUtils.readXML(this.myContextList.getDiskModel());
        ContextListTest.assertEquals(0, this.myContextList.getNamesList().length);
        ContextListTest.assertEquals(0, theDom.getElementsByTagName("context").getLength());
    }

    public void testToXML() {
        ContextListTest.assertEquals(this.myContextList.getNamesList().length, this.myContextList.toXML().getElementsByTagName("context").getLength());
    }

    public void testLoadXML() {
        File contextsFile = new File(this.baseDir, "3ContextsList.xml");
        this.myContextList.loadXML(contextsFile);
        ContextListTest.assertEquals(3, this.myContextList.getNamesList().length);
    }

    public void testAddAnotherContext() {
        String contextName = "Another Context Name";
        this.myContextList.addContext(new ContextModel(contextName));
        ContextListTest.assertTrue(this.myContextList.checkConsistency());
    }
}

