/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.awt.Dimension;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import models.AttachmentList;
import models.AttachmentType;

public class AttachmentListTable
extends JTable {
    private JComboBox linkCombo;

    public AttachmentListTable(AttachmentList tableModel) {
        super(tableModel);
        this.setup();
    }

    public void setup() {
        JComboBox<String> typeCombo = new JComboBox<String>();
        TableColumn typeColumn = this.getColumnModel().getColumn(2);
        AttachmentType[] attachmentTypeArray = AttachmentType.values();
        int n = attachmentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttachmentType type = attachmentTypeArray[n2];
            typeCombo.addItem(type.toString());
            ++n2;
        }
        typeColumn.setCellEditor(new DefaultCellEditor(typeCombo));
        TableColumn linkColumn = this.getColumnModel().getColumn(3);
        this.feedLinkCombo();
        linkColumn.setCellEditor(new DefaultCellEditor(this.linkCombo));
        this.setPreferredScrollableViewportSize(new Dimension(400, 200));
        TableColumn col = null;
        int i = 0;
        while (i < this.getColumnModel().getColumnCount()) {
            col = this.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    col.setPreferredWidth(20);
                    break;
                }
                case 2: {
                    col.setPreferredWidth(50);
                    break;
                }
                case 3: {
                    col.setPreferredWidth(50);
                    break;
                }
                default: {
                    col.setPreferredWidth(300);
                }
            }
            ++i;
        }
    }

    public void feedLinkCombo() {
        if (this.linkCombo == null) {
            this.linkCombo = new JComboBox();
        }
        this.linkCombo.removeAllItems();
        this.linkCombo.addItem("none");
        File[] fileArray = ((AttachmentList)this.getModel()).getFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileName = fileArray[n2];
            this.linkCombo.addItem(fileName.getName());
            ++n2;
        }
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        super.tableChanged(event);
        this.feedLinkCombo();
    }
}

