/*
 * Decompiled with CFR 0.152.
 */
package futils;

import exceptions.ArchiveException;
import exceptions.EmptyArchiveException;
import exceptions.WrongArchiveException;
import futils.FileCopy;
import futils.StringableFile;
import futils.ZipArchive;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import junit.framework.TestCase;

public class ZipArchiveTest
extends TestCase {
    String baseName = "test-datas";
    File baseDir = new File(this.baseName);
    ArrayList<File> myFileList = new ArrayList();
    String myArchName = String.valueOf(this.baseName) + File.separator + "myTestArchive.zip";
    File myZipFile = new File(this.myArchName);
    ZipArchive myZipArchive = null;
    String[] fileNames = new String[]{"uno.txt", "dos.txt", "tres.txt"};
    File destDir = new File("destDir");
    File newDir = new File("moreDir");
    String name = "FOCUS_20090529_Craie_Normande__Earth_CESR___3265mm_000";
    ZipArchive ourArchive = new ZipArchive(new File(this.baseDir, String.valueOf(this.name) + ".zip"));

    public ZipArchiveTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        String file;
        super.setUp();
        this.destDir.mkdir();
        this.myZipArchive = new ZipArchive(this.myArchName);
        this.myZipFile = new File(this.myArchName);
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            file = stringArray[n2];
            this.myFileList.add(StringableFile.writeFileAsString(file, String.valueOf(file) + "\n"));
            ++n2;
        }
        this.newDir.mkdir();
        stringArray = this.fileNames;
        n = this.fileNames.length;
        n2 = 0;
        while (n2 < n) {
            file = stringArray[n2];
            this.myFileList.add(StringableFile.writeFileAsString("moreDir" + File.separator + file, String.valueOf(file) + "\n"));
            ++n2;
        }
        this.myZipArchive.add(this.myFileList);
        this.myZipArchive.write();
    }

    @Override
    protected void tearDown() {
        System.out.println(String.valueOf(this.getName()) + ": " + this.myZipFile.exists());
        FileCopy.RecurseDelete(this.destDir);
        FileCopy.RecurseDelete(this.newDir);
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            new File(fileName).delete();
            ++n2;
        }
        this.myZipFile.delete();
    }

    public void testZipArchive() {
        ZipArchive thisZA = new ZipArchive("snth");
        ZipArchiveTest.assertNotNull(thisZA);
    }

    public void testAdd() {
        ZipArchiveTest.assertEquals(this.myFileList.size(), this.myZipArchive.getLength());
    }

    public void testRaiseEmptyArchive() {
        ZipArchive emptyArch = new ZipArchive("emptyArch.zip");
        try {
            this.myZipArchive.write();
        }
        catch (EmptyArchiveException e) {
            ZipArchiveTest.assertTrue(true);
        }
        catch (ArchiveException e) {
            ZipArchiveTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
    }

    public void testWriteOk() {
        try {
            this.myZipArchive.write();
        }
        catch (Exception e) {
            ZipArchiveTest.assertFalse(e.getMessage(), true);
        }
        ZipArchiveTest.assertTrue(this.myZipFile.exists());
        ZipArchiveTest.assertEquals(this.myZipArchive.getFileName(), this.myZipFile.getName());
    }

    public void testWriteFromFile() {
        String fileName = "thearchfile.zip";
        File archFile = new File(this.baseDir, fileName);
        ZipArchive theArch = new ZipArchive(archFile);
        theArch.add(this.myFileList);
        File theFile = null;
        try {
            theFile = theArch.write();
        }
        catch (Exception e) {
            ZipArchiveTest.assertFalse(e.getMessage(), true);
        }
        try {
            System.out.println(theFile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ZipArchiveTest.assertEquals(fileName, theFile.getName());
        ZipArchiveTest.assertTrue(theFile.exists());
        archFile.delete();
    }

    public void testArchDir() {
        ArrayList<File> filesInDir = new ArrayList<File>();
        File myDir = new File("myDir");
        myDir.mkdir();
        ZipArchive dirArch = new ZipArchive("dirArch.zip");
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            filesInDir.add(new File(myDir, String.valueOf(file) + ".txt"));
            this.myFileList.add(StringableFile.writeFileAsString(new File(myDir, String.valueOf(file) + ".txt"), String.valueOf(file) + "\n"));
            ++n2;
        }
        dirArch.add(filesInDir);
        try {
            dirArch.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ZipArchiveTest.assertTrue(myDir.listFiles().length > 0);
        FileCopy.RecurseDelete(myDir);
        new File("dirArch.zip").delete();
    }

    public void testGetEntries() {
        ArrayList<String> myList = null;
        try {
            myList = this.ourArchive.getEntries();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        for (String file : myList) {
            System.out.println("file: " + file.toString());
        }
        ZipArchiveTest.assertEquals(6, myList.size());
    }

    public void testGetFileEntry() {
        File myFile = this.ourArchive.getFileEntry(String.valueOf(this.name) + ".xml");
        ZipArchiveTest.assertTrue(myFile.exists());
        ZipArchiveTest.assertTrue(myFile.isFile());
        myFile.delete();
    }

    public void testGetExtractedEntries() {
        ArrayList<File> myList = null;
        try {
            myList = this.myZipArchive.getExtractedEntries();
        }
        catch (WrongArchiveException e) {
            e.printStackTrace();
        }
        for (File file : myList) {
            ZipArchiveTest.assertTrue(file.isFile() && file.exists());
        }
    }

    public void testGetExtractedEntriesTo() {
        ArrayList<File> myList = null;
        try {
            myList = this.myZipArchive.getExtractedEntries(this.destDir);
        }
        catch (WrongArchiveException e) {
            e.printStackTrace();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (File file : myList) {
            ZipArchiveTest.assertTrue(file.isFile() && file.exists());
        }
    }

    public void testExtractTo() {
        this.destDir = new File(this.baseDir, "testZipDir");
        this.destDir.mkdir();
        try {
            this.myZipArchive.extractTo(this.destDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            ZipArchiveTest.fail("unexpected exception: " + e.getMessage());
        }
        ZipArchiveTest.assertTrue(this.destDir.listFiles().length > 0);
    }

    public void testAddDirContents() throws EmptyArchiveException, WrongArchiveException, ZipException, IOException {
        this.myZipArchive.addDirContents(new File(this.baseDir, "productDirToLoad"));
        File aoeu = this.myZipArchive.write();
        ZipArchiveTest.assertTrue(aoeu.exists());
    }

    public void testBinaryNotCorrupted() throws WrongArchiveException, EmptyArchiveException, ZipException, IOException {
        String fishImageName = this.baseDir + File.separator + "FishImage.png";
        File fishImage = new File(fishImageName);
        File destDir = new File("destDir");
        destDir.mkdir();
        this.myZipArchive.add(new File[]{fishImage});
        this.myZipArchive.write();
        this.myZipArchive.extractTo(destDir);
        File extractedFish = new File(destDir, fishImageName);
        System.out.println(extractedFish.getCanonicalPath());
        ZipArchiveTest.assertTrue(extractedFish.exists());
        ZipArchiveTest.assertTrue(fishImage.exists());
        ZipArchiveTest.assertEquals(extractedFish.length(), fishImage.length());
    }
}

