/*
 * Decompiled with CFR 0.152.
 */
package forms;

import gutils.FormObserver;
import gutils.FormPanel;
import gutils.GridBag;
import gutils.HLinkBox;
import gutils.VLinkBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import models.ContextKey;

public class EnvironmentFormTab
extends FormPanel {
    public EnvironmentFormTab(FormObserver fo) {
        super(fo);
        this.setLayout(new GridBagLayout());
        GridBagConstraints commonConst = new GridBagConstraints();
        commonConst.anchor = 23;
        commonConst.insets = new Insets(10, 0, 0, 20);
        commonConst.fill = 2;
        GridBagConstraints[] myGrid = GridBag.GetGrid(2, 4, commonConst);
        int gridIndex = 0;
        JLabel envHeading = new JLabel("ENVIRONMENT: define as accurately as possible, the target atmosphere environment");
        this.fixHeadingLabel(envHeading);
        myGrid[gridIndex].gridwidth = 2;
        myGrid[gridIndex].ipady = 100;
        this.add((Component)envHeading, myGrid[gridIndex++]);
        JLabel atmLabel = new JLabel("atmosphere");
        JRadioButton earthRadio = new JRadioButton("Earth");
        JRadioButton marsRadio = new JRadioButton("Mars");
        JRadioButton otherRadio = new JRadioButton("Other");
        ButtonGroup atmGroup = new ButtonGroup();
        atmGroup.add(earthRadio);
        atmGroup.add(marsRadio);
        atmGroup.add(otherRadio);
        atmGroup.setSelected(earthRadio.getModel(), true);
        JLabel co2Label = new JLabel("% CO2");
        JLabel n2Label = new JLabel("% N2");
        JLabel arLabel = new JLabel("% Ar");
        JTextField co2TField = new JTextField();
        JTextField n2TField = new JTextField();
        JTextField arTField = new JTextField();
        Dimension tfieldWidth = new Dimension(30, 30);
        co2TField.setMaximumSize(tfieldWidth);
        n2TField.setMaximumSize(tfieldWidth);
        arTField.setMaximumSize(tfieldWidth);
        VLinkBox marsAtmBox = new VLinkBox(new Component[]{new HLinkBox(new Component[]{co2TField, co2Label}), new HLinkBox(new Component[]{n2TField, n2Label}), new HLinkBox(new Component[]{arTField, arLabel})});
        marsRadio.setAlignmentY(0.0f);
        marsAtmBox.setAlignmentY(0.0f);
        HLinkBox marsBox = new HLinkBox(marsRadio, marsAtmBox);
        JTextField otherAtmTField = new JTextField(20);
        HLinkBox otherBox = new HLinkBox(otherRadio, otherAtmTField);
        marsBox.setAlignmentX(0.0f);
        otherBox.setAlignmentX(0.0f);
        VLinkBox atmRadioBox = new VLinkBox(new Component[]{earthRadio, marsBox, otherBox});
        atmRadioBox.setBorder(RADIO_BORDER);
        int n = ++gridIndex;
        this.add((Component)atmLabel, myGrid[n]);
        int n2 = ++gridIndex;
        this.add((Component)atmRadioBox, myGrid[n2]);
        this.getMap().put(ContextKey.ATM_COMPOSITION, atmGroup);
        this.getMap().put(ContextKey.ATM_MARS_CO2, co2TField);
        this.getMap().put(ContextKey.ATM_MARS_N2, n2TField);
        this.getMap().put(ContextKey.ATM_MARS_AR, arTField);
        this.getMap().put(ContextKey.ATM_OTHER, otherAtmTField);
        JLabel pressureLabel = new JLabel("pressure");
        JRadioButton ambRadio = new JRadioButton("Ambiant");
        JRadioButton ctrlRadio = new JRadioButton("Controlled");
        ButtonGroup pressureGroup = new ButtonGroup();
        pressureGroup.add(ambRadio);
        pressureGroup.add(ctrlRadio);
        JTextField ctrlPressTField = new JTextField();
        ctrlPressTField.setMaximumSize(new Dimension(50, 30));
        HLinkBox ctrlBox = new HLinkBox(new Component[]{ctrlRadio, ctrlPressTField, new JLabel("(mbar)")});
        ctrlBox.setAlignmentX(0.0f);
        VLinkBox pressureBox = new VLinkBox(ambRadio, ctrlBox);
        pressureBox.setBorder(RADIO_BORDER);
        int n3 = ++gridIndex;
        this.add((Component)pressureLabel, myGrid[n3]);
        int n4 = ++gridIndex;
        ++gridIndex;
        GridBagConstraints thisConstraint = myGrid[n4];
        thisConstraint.fill = 2;
        this.add((Component)pressureBox, thisConstraint);
        this.getMap().put(ContextKey.PRESSURE, pressureGroup);
        this.getMap().put(ContextKey.PRESSURE_CTRL, ctrlPressTField);
        myGrid[gridIndex].gridwidth = 2;
        myGrid[gridIndex].fill = 2;
        this.add((Component)this.getCheckerButton(), myGrid[gridIndex++]);
    }
}

