/*
 * Decompiled with CFR 0.152.
 */
package futils;

import exceptions.EmptyArchiveException;
import exceptions.WrongArchiveException;
import futils.FileCopy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipArchive {
    static final int BUFFER = 2048;
    private File archFile;
    private TreeMap<String, File> fileMap = new TreeMap();

    public ZipArchive(File archFile) {
        this.archFile = archFile;
    }

    public ZipArchive(String archName) {
        this(new File(archName));
    }

    public boolean add(File[] fileList) {
        this.fileMap.clear();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.fileMap.put(file.getPath(), file);
            ++n2;
        }
        return true;
    }

    public boolean add(ArrayList<File> fileList) {
        this.add(fileList.toArray(new File[fileList.size()]));
        return true;
    }

    public boolean addDirContents(File directory) {
        this.fileMap.clear();
        File[] fileArray = FileCopy.RecurseTree(directory);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String key = file.getAbsolutePath().replace(String.valueOf(directory.getAbsolutePath()) + File.separator, "");
            key = key.replace(File.separator.toCharArray()[0], '/');
            this.fileMap.put(key, file);
            ++n2;
        }
        return true;
    }

    public File write() throws EmptyArchiveException, WrongArchiveException {
        byte[] data = new byte[2048];
        if (this.getLength() == 0) {
            throw new EmptyArchiveException();
        }
        try {
            FileOutputStream dest = new FileOutputStream(this.archFile);
            BufferedOutputStream buff = new BufferedOutputStream(dest);
            ZipOutputStream zout = new ZipOutputStream(buff);
            for (Map.Entry<String, File> e : this.fileMap.entrySet()) {
                String name = e.getKey();
                File currFile = e.getValue();
                ZipEntry currEntry = new ZipEntry(name);
                zout.putNextEntry(currEntry);
                if (currFile.isFile()) {
                    int count;
                    FileInputStream fi = new FileInputStream(currFile);
                    BufferedInputStream buffi = new BufferedInputStream(fi, 2048);
                    while ((count = buffi.read(data, 0, 2048)) != -1) {
                        zout.write(data, 0, count);
                    }
                    buffi.close();
                }
                zout.closeEntry();
            }
            zout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WrongArchiveException(e.getMessage());
        }
        return this.archFile;
    }

    public int getLength() {
        return this.fileMap.size();
    }

    public String getFileName() {
        return this.archFile.getName();
    }

    public ArrayList<String> getEntries() throws WrongArchiveException {
        ZipFile zf;
        ArrayList<String> entriesList = new ArrayList<String>();
        try {
            zf = new ZipFile(this.archFile);
        }
        catch (Exception e) {
            throw new WrongArchiveException(e.getMessage());
        }
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            entriesList.add(ze.getName());
        }
        return entriesList;
    }

    public File getFileEntry(String zipEntryName) {
        try {
            ZipFile myZF = new ZipFile(this.archFile);
            ZipEntry myZE = myZF.getEntry(zipEntryName);
            System.out.println(zipEntryName);
            FileCopy.CopyInputStream(myZF.getInputStream(myZE), new BufferedOutputStream(new FileOutputStream(zipEntryName)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new File(zipEntryName);
    }

    public ArrayList<File> getExtractedEntries() throws WrongArchiveException {
        ArrayList<File> resultList = new ArrayList<File>();
        for (String filename : this.getEntries()) {
            File theFile = this.getFileEntry(filename);
            resultList.add(theFile);
        }
        return resultList;
    }

    public ArrayList<File> getExtractedEntries(File destDir) throws ZipException, IOException, WrongArchiveException {
        this.extractTo(destDir);
        ArrayList<File> resultList = new ArrayList<File>();
        for (String filename : this.getEntries()) {
            resultList.add(new File(filename));
        }
        return resultList;
    }

    public File extractTo(File destDir) throws ZipException, IOException {
        Enumeration<? extends ZipEntry> entries = null;
        ZipFile zipFile = new ZipFile(this.archFile);
        entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File destinationFile = new File(destDir, entry.getName());
            destinationFile.getParentFile().mkdirs();
            if (entry.isDirectory()) continue;
            FileCopy.CopyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destinationFile)));
        }
        zipFile.close();
        return destDir;
    }
}

