/*
 * Decompiled with CFR 0.152.
 */
package views;

import exceptions.ArchiveException;
import exceptions.WrongProductFileException;
import gutils.GridBag;
import gutils.VLinkBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import models.AttachmentList;
import models.AttachmentListTable;
import models.ContextList;
import models.ContextModel;
import models.FinalProduct;
import mvc.FinalView;
import mvc.ProductChangedEvent;
import views.CgdlPanel;

public class LinkPanel
extends FinalView
implements Observer {
    private static final long serialVersionUID = 1L;
    ContextModel myContext;
    File[] fileList;
    JPanel mainPanel;
    private JLabel selectedContexLabel;
    private JTable attachmentTable;
    private JScrollPane selectFilesScroll;
    private JButton selectFilesBtn;
    private JButton saveBtn;
    private JButton removeFilesBtn;
    private JLabel numFilesLabel;
    private JLabel linkResultLabel;
    private JTextField calibrationJText;
    private JButton addCalibration;
    private JTextField fileNameField;
    private JTextArea showRoomArea;
    private JScrollPane showRoomScroll;
    private JLabel resultMakeLabel;
    private CgdlPanel myContainer;
    private FinalProduct myProduct;

    public LinkPanel(CgdlPanel myContainer, FinalProduct myProduct) {
        super(myContainer);
        this.myContainer = myContainer;
        this.myProduct = myProduct;
        this.myContext = myProduct.getContext();
        this.mainPanel = new JPanel(new GridBagLayout());
        this.makePanel();
    }

    @Override
    public void makePanel() {
        GridBagConstraints cmnConstraints = new GridBagConstraints();
        cmnConstraints.gridwidth = 1;
        cmnConstraints.gridheight = 1;
        cmnConstraints.weightx = 0.0;
        cmnConstraints.weighty = 0.1;
        cmnConstraints.anchor = 23;
        cmnConstraints.fill = 2;
        cmnConstraints.insets = new Insets(0, 0, 0, 5);
        cmnConstraints.ipadx = 0;
        cmnConstraints.ipady = 0;
        int btnFill = 2;
        int aeraFill = 1;
        GridBagConstraints[] myGrid = GridBag.GetGrid(2, 4, cmnConstraints);
        int gridIndex = 0;
        this.setLayout(new GridBagLayout());
        this.attachmentTable = new AttachmentListTable(this.myProduct.getAttachmentsList());
        this.selectedContexLabel = new JLabel(this.myContext.getName());
        this.selectedContexLabel.setFont(new Font("Sans", 1, 14));
        this.selectedContexLabel.setForeground(Color.BLUE);
        JButton btnClearContext = new JButton("Make new Product");
        btnClearContext.setToolTipText("Removes all attachments and sets the selected context for new product");
        JButton btnLoadProductXml = new JButton("Load Old Zip Product");
        btnLoadProductXml.setToolTipText("Get context and file attachments from an existing zip archive");
        btnLoadProductXml.addActionListener(this.myContainer.new CgdlPanel.LoadProduct());
        JLabel selectContextLabel = new JLabel("Your Context Selected:  ");
        JButton myContextChooser = this.myContainer.getChooseContextButton();
        myContextChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkPanel.this.myProduct.clearAttachments();
            }
        });
        myGrid[++gridIndex].fill = btnFill;
        this.mainPanel.add((Component)new VLinkBox(new Component[]{myContextChooser, btnLoadProductXml}), myGrid[gridIndex++]);
        this.selectFilesBtn = new JButton("Add Numerical Files");
        this.selectFilesBtn.addActionListener(new ChooseNumericalFiles());
        this.removeFilesBtn = new JButton("Remove Selected Items");
        this.removeFilesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = LinkPanel.this.attachmentTable.getSelectedRows();
                ((AttachmentList)LinkPanel.this.attachmentTable.getModel()).removeRows(selectedRows);
            }
        });
        this.linkResultLabel = new JLabel("no link yet");
        this.selectFilesScroll = new JScrollPane(this.attachmentTable, 22, 31);
        myGrid[gridIndex].fill = aeraFill;
        this.mainPanel.add((Component)new VLinkBox(this.selectFilesScroll, this.linkResultLabel), myGrid[gridIndex++]);
        myGrid[gridIndex].fill = btnFill;
        this.mainPanel.add((Component)new VLinkBox(new Component[]{this.selectFilesBtn, this.removeFilesBtn}), myGrid[gridIndex++]);
        this.saveBtn = new JButton("Save Final Product");
        this.saveBtn.setToolTipText("Write context and attached files to a zip archive onto local disk");
        this.saveBtn.addActionListener(new SaveFile());
        this.fileNameField = new JTextField(this.myProduct.getFileName());
        this.resultMakeLabel = new JLabel("nothing saved yet");
        VLinkBox fileNamesBox = new VLinkBox(this.fileNameField, this.resultMakeLabel);
        this.mainPanel.add((Component)fileNamesBox, myGrid[gridIndex++]);
        myGrid[gridIndex].fill = btnFill;
        this.mainPanel.add((Component)this.saveBtn, myGrid[gridIndex++]);
        this.showRoomArea = new JTextArea(20, 40);
        this.showRoomScroll = new JScrollPane(this.showRoomArea, 22, 32);
        JButton doneBtn = new JButton("Back Home Page");
        doneBtn.addActionListener(this.myContainer.new CgdlPanel.ShowWelcomePanel());
        myGrid[gridIndex].fill = aeraFill;
        this.mainPanel.add((Component)this.showRoomScroll, myGrid[gridIndex++]);
        myGrid[gridIndex].fill = btnFill;
        this.mainPanel.add((Component)doneBtn, myGrid[gridIndex++]);
    }

    @Override
    public JComponent getPanel() {
        return this.mainPanel;
    }

    @Override
    public void updateComponents(FinalProduct theModel) {
        String filename = theModel.getFileName();
        this.fileNameField.setText(filename);
        this.selectedContexLabel.setText(theModel.getContext().getName());
        this.linkResultLabel.setText(String.valueOf(this.attachmentTable.getModel().getRowCount()) + " files linked to " + theModel.getContext().getName());
        this.resultMakeLabel.setForeground(Color.RED);
        this.resultMakeLabel.setText(String.valueOf(this.myProduct.getName()) + " changed; remind to save");
        String xmlStr = this.myProduct.toString();
        this.showRoomArea.setText(xmlStr);
        this.revalidate();
    }

    @Override
    public void finalChanged(ProductChangedEvent productChangedEvent) {
        this.updateComponents(productChangedEvent.getModel());
    }

    public void changeContext(ContextList theCL) {
        this.myProduct.setContext(theCL.getSelectedContext());
    }

    @Override
    public void update(Observable ob, Object o) {
        this.changeContext((ContextList)o);
    }

    public class AddCalibration
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser myChooser = new JFileChooser();
            myChooser.setMultiSelectionEnabled(false);
            int chooserRes = myChooser.showOpenDialog(LinkPanel.this);
            if (chooserRes == 1) {
                return;
            }
        }
    }

    public class ChooseNumericalFiles
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser myChooser = new JFileChooser();
            myChooser.setPreferredSize(new Dimension(900, 500));
            String numericalsDirName = System.getProperty("user.attachDir");
            if (numericalsDirName != null) {
                myChooser.setCurrentDirectory(new File(numericalsDirName));
            }
            myChooser.setMultiSelectionEnabled(true);
            int chooserRes = myChooser.showOpenDialog(LinkPanel.this);
            if (chooserRes == 1) {
                return;
            }
            try {
                System.setProperty("user.attachDir", myChooser.getCurrentDirectory().getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            LinkPanel.this.myProduct.addNumericals(myChooser.getSelectedFiles());
        }
    }

    public class LinkToContext
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("not available any more");
        }
    }

    public class SaveFile
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int choice;
            JFileChooser myChooser = new JFileChooser();
            String archiveDirName = System.getProperty("user.archiveDir");
            if (archiveDirName != null) {
                myChooser.setCurrentDirectory(new File(archiveDirName));
            }
            myChooser.setSelectedFile(new File(LinkPanel.this.fileNameField.getText()));
            myChooser.setDialogType(1);
            int chooserRes = myChooser.showSaveDialog(LinkPanel.this);
            if (chooserRes == 1) {
                return;
            }
            File selectedFile = myChooser.getSelectedFile();
            if (selectedFile.exists() && 1 == (choice = JOptionPane.showConfirmDialog(null, "Zip File Exists\nDo you want to Overwrite ?", selectedFile.getName(), 0))) {
                return;
            }
            try {
                System.setProperty("user.archiveDir", selectedFile.getParentFile().getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            LinkPanel.this.myProduct.setFile(selectedFile);
            File resultFile = null;
            try {
                resultFile = LinkPanel.this.myProduct.toZip();
            }
            catch (ArchiveException except) {
                LinkPanel.this.resultMakeLabel.setForeground(Color.RED);
                LinkPanel.this.resultMakeLabel.setText("no data attached");
            }
            catch (WrongProductFileException except) {
                LinkPanel.this.resultMakeLabel.setText(except.getMessage());
            }
            LinkPanel.this.resultMakeLabel.setForeground(Color.BLUE);
            long fileOctets = resultFile.length();
            String fileLength = fileOctets < 1024L ? String.valueOf(String.valueOf(fileOctets)) + " o" : (fileOctets < 0x100000L ? String.valueOf(String.valueOf(fileOctets / 1024L)) + " ko" : (fileOctets < 0x40000000L ? String.valueOf(String.valueOf(fileOctets / 0x100000L)) + " Mo" : String.valueOf(String.valueOf(fileOctets / 0x40000000L)) + " Go"));
            LinkPanel.this.resultMakeLabel.setText("saved into " + resultFile.getName() + ": " + fileLength);
        }
    }
}

