/*
 * Decompiled with CFR 0.152.
 */
package views;

import gutils.VLinkBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import models.ContextList;
import models.ContextModel;

public class ContextListPanel
extends JFrame
implements ActionListener,
Observer {
    public ContextList ourContextList = null;
    public JComboBox theJCombo = new JComboBox();
    private JButton deleteCtxBtn;
    private JButton setCtxBtn;

    public ContextListPanel(ContextList theCL) {
        theCL.addObserver(this);
        this.ourContextList = theCL;
        this.setWindow();
        this.updateComponents(theCL);
    }

    public void setWindow() {
        this.setCtxBtn = new JButton("Choose");
        this.setCtxBtn.setActionCommand("set");
        this.deleteCtxBtn = new JButton("Delete");
        this.deleteCtxBtn.setActionCommand("delete");
        JButton okBtn = new JButton("Ok");
        okBtn.setActionCommand("ok");
        JButton cancelBtn = new JButton("Close");
        cancelBtn.setActionCommand("cancel");
        this.setCtxBtn.addActionListener(this);
        this.deleteCtxBtn.addActionListener(this);
        okBtn.addActionListener(this);
        cancelBtn.addActionListener(this);
        JPanel pane = new JPanel();
        pane.add((Component)this.theJCombo, "Before");
        pane.add((Component)new VLinkBox(new JComponent[]{this.setCtxBtn, this.deleteCtxBtn, (JComponent)Box.createVerticalGlue(), cancelBtn}), "After");
        this.setContentPane(pane);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 250);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedItem = (String)this.theJCombo.getSelectedItem();
        if (e.getActionCommand().equals("set")) {
            this.ourContextList.setSelected(selectedItem);
        }
        if (e.getActionCommand().equals("delete")) {
            this.ourContextList.deleteContext(selectedItem);
        }
        if (e.getActionCommand().equals("ok") || e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.updateComponents((ContextList)arg1);
    }

    public void updateComponents(ContextList argContext) {
        this.ourContextList = argContext;
        this.theJCombo.setModel(new DefaultComboBoxModel<String>(argContext.getNamesList()));
        if (argContext.getNamesList().length == 0) {
            this.deleteCtxBtn.setEnabled(false);
            this.setCtxBtn.setEnabled(false);
            this.theJCombo.setModel(new DefaultComboBoxModel<String>(new String[]{new ContextModel().getName()}));
            this.theJCombo.setEnabled(false);
        } else {
            this.deleteCtxBtn.setEnabled(true);
            this.setCtxBtn.setEnabled(true);
            this.theJCombo.setEnabled(true);
            this.theJCombo.setSelectedItem(argContext.getSelected());
        }
    }
}

