/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.ArchiveException;
import exceptions.WrongArchiveException;
import exceptions.WrongAttachmentAttribute;
import exceptions.WrongProductFileException;
import futils.FileCopy;
import futils.StringableFile;
import futils.XmlUtils;
import futils.ZipArchive;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import junit.framework.TestCase;
import models.ContextModel;
import models.FinalProduct;
import mvc.FinalListener;
import mvc.ProductChangedEvent;
import org.w3c.dom.Document;

public class FinalProductTest
extends TestCase {
    String baseDirName = "test-datas";
    MyListener myListener = null;
    FinalProduct myFinalProduct = null;
    String inputName = "FOCUS_20090529_Craie_Normande__Earth_CESR___3265mm_000";
    File inputFile = new File(this.baseDirName, String.valueOf(this.inputName) + ".zip");
    String outputName = "FOCUS_20090529_Craie_Normande__CESR__3265__OUT";
    File outputFile = new File(this.baseDirName, String.valueOf(this.outputName) + ".zip");
    File resultFile = null;
    File productDir = new File(String.valueOf(this.baseDirName) + File.separator + "productDirToLoad");
    File tempDir = new File(this.baseDirName, "TempDir");
    File fsDir = null;

    public FinalProductTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myListener = new MyListener();
        ContextModel myContextModel = new ContextModel();
        File contextFile = new File(this.productDir, String.valueOf(this.inputName) + ".xml");
        myContextModel.loadXML(contextFile);
        this.myFinalProduct = new FinalProduct(myContextModel);
        this.myFinalProduct.addNumericals(new File(this.productDir, this.inputName).listFiles());
        FinalProductTest.assertTrue(this.inputFile.length() > 0L);
        this.tempDir.mkdir();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        System.err.println("DO WE?");
        this.myListener = null;
        this.myFinalProduct = null;
        if (this.resultFile != null) {
            this.resultFile.delete();
        }
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        if (this.tempDir != null && this.tempDir.isDirectory()) {
            FileCopy.RecurseDelete(this.tempDir);
        }
        if (this.fsDir != null && this.fsDir.isDirectory()) {
            FileCopy.RecurseDelete(this.fsDir);
        }
    }

    public void testGetListeners() {
        this.myFinalProduct.addListener(this.myListener);
        FinalProductTest.assertNotNull(this.myFinalProduct.getListeners());
    }

    public void testAddListener() {
        this.myFinalProduct.addListener(this.myListener);
        FinalListener[] listeners = this.myFinalProduct.getListeners();
        FinalProductTest.assertTrue(this.myFinalProduct.hasListener(this.myListener));
    }

    public void testFireModelChanged() {
        this.myFinalProduct.addListener(this.myListener);
        this.myFinalProduct.fireModelChanged();
        FinalProductTest.assertTrue(this.myListener.modelChanged);
    }

    public void testLoadZip() throws IOException {
        System.out.println(this.inputFile.getAbsolutePath());
        try {
            this.myFinalProduct.loadZip(this.inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
        FinalProductTest.assertEquals(this.inputName, this.myFinalProduct.getContext().getName());
        FinalProductTest.assertEquals(5, this.myFinalProduct.getNumericals().length);
    }

    public void testLoadZipFromNew() throws IOException {
        System.out.println(this.inputFile.getAbsolutePath());
        FinalProduct aProduct = new FinalProduct(new ContextModel());
        try {
            aProduct.loadZip(this.inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
        FinalProductTest.assertEquals(this.inputName, aProduct.getContext().getName());
        FinalProductTest.assertEquals(5, aProduct.getNumericals().length);
    }

    public void testLoadZipUponOldExtractDir() {
        this.tempDir = new File("extractDir");
        this.tempDir.mkdir();
        File addedFile = new File(this.tempDir, "stuff.bad_ext");
        StringableFile.writeFileAsString(addedFile, "some stuff in it");
        try {
            this.myFinalProduct.loadZip(this.inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
        FinalProductTest.assertEquals(this.inputName, this.myFinalProduct.getContext().getName());
        FinalProductTest.assertEquals(5, this.myFinalProduct.getNumericals().length);
    }

    public void testToZip() throws WrongArchiveException {
        try {
            this.resultFile = this.myFinalProduct.toZip(this.outputFile);
        }
        catch (ArchiveException e) {
            FinalProductTest.fail("shouldnt raise " + e.getMessage());
        }
        catch (WrongProductFileException e) {
            FinalProductTest.fail("shouldnt raise " + e.getMessage());
        }
        ArrayList<String> entriesList = new ZipArchive(this.resultFile).getEntries();
        FinalProductTest.assertTrue(this.resultFile.exists());
        FinalProductTest.assertEquals(6, entriesList.size());
    }

    public void testSetFileName() {
        File resultFile = null;
        String filename = "myfilename.zeep";
        this.myFinalProduct.setFileName(filename);
        try {
            resultFile = this.myFinalProduct.toZip();
        }
        catch (ArchiveException e) {
            FinalProductTest.fail("shouldnt raise EmptyArchiveException");
        }
        catch (WrongProductFileException e) {
            FinalProductTest.fail("shouldnt raise EmptyArchiveException");
        }
        FinalProductTest.assertEquals(filename, resultFile.getName());
        FinalProductTest.assertTrue(resultFile.exists());
        resultFile.delete();
    }

    public void testToFS() {
        System.out.println(this.inputFile.getAbsolutePath());
        try {
            this.myFinalProduct.loadZip(this.inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
        try {
            this.tempDir = this.myFinalProduct.toFS();
        }
        catch (WrongProductFileException e) {
            e.printStackTrace();
        }
        FinalProductTest.assertTrue(this.tempDir.exists());
    }

    public void testLoad2Zip() {
        File resultFile = null;
        try {
            this.myFinalProduct.loadZip(this.inputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
        try {
            resultFile = this.myFinalProduct.toZip(this.outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
        }
        FinalProductTest.assertTrue(resultFile.exists());
        FinalProductTest.assertTrue(resultFile.length() > 0L);
    }

    public void testLoadFS() {
        try {
            FileCopy.RecurseCopy(this.productDir, this.tempDir);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        FileCopy.RecurseDelete(new File(this.tempDir, ".svn"));
        try {
            this.myFinalProduct.loadFS(this.tempDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.fail("unexpected exception " + e.getMessage());
        }
        FinalProductTest.assertEquals(5, this.myFinalProduct.getNumericals().length);
    }

    public void testBinaryCorrupted() throws WrongProductFileException {
        File fishImage = new File(this.baseDirName, "FishImage.png");
        this.myFinalProduct.addNumericals(new File[]{fishImage});
        this.fsDir = this.myFinalProduct.toFS();
        File extractedFish = new File(this.fsDir, String.valueOf(this.myFinalProduct.getName()) + File.separator + "FishImage.png");
        FinalProductTest.assertEquals(extractedFish.length(), fishImage.length());
    }

    public void testRemoveNumerical() {
        File[] numericalsList = this.myFinalProduct.getNumericals();
        int initLength = numericalsList.length;
        this.myFinalProduct.removeNumerical(numericalsList[0]);
        FinalProductTest.assertEquals(initLength - 1, this.myFinalProduct.getNumericals().length);
    }

    public void testGetMetaXml() {
        Document myDom = this.myFinalProduct.getMetaXml();
        FinalProductTest.assertEquals(1, myDom.getElementsByTagName("context").getLength());
    }

    public void testSaveAndLoad() {
        int nbAttachIni = this.myFinalProduct.getNumericals().length;
        try {
            this.resultFile = this.myFinalProduct.toZip();
            System.out.println(this.resultFile.getCanonicalPath());
            this.myFinalProduct.loadZip(this.resultFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.fail(e.getMessage());
        }
        int nbAttachRes = this.myFinalProduct.getNumericals().length;
        FinalProductTest.assertEquals(nbAttachIni, nbAttachRes);
    }

    public void testToZipEmptyXml() {
        Document myDom = null;
        try {
            this.resultFile = this.myFinalProduct.toZip();
            ZipArchive myArchive = new ZipArchive(this.resultFile);
            for (String entryName : myArchive.getEntries()) {
                System.out.println(entryName);
            }
            File myXmlFile = myArchive.getFileEntry(String.valueOf(this.inputName) + ".xml");
            myDom = XmlUtils.readXML(myXmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.fail(e.getMessage());
        }
        FinalProductTest.assertEquals(1, myDom.getElementsByTagName("context").getLength());
    }

    public void testToFsEmptyXml() {
        try {
            this.fsDir = this.myFinalProduct.toFS();
        }
        catch (WrongProductFileException e) {
            e.printStackTrace();
            FinalProductTest.fail("shouldnt raise exception");
        }
        String xmlFileName = String.valueOf(this.myFinalProduct.getName()) + ".xml";
        Document myDom = XmlUtils.readXML(new File(this.fsDir, xmlFileName));
        FinalProductTest.assertEquals(1, myDom.getElementsByTagName("context").getLength());
    }

    public void testNumericalToXml() {
        File[] numericalsList = this.myFinalProduct.getNumericals();
        int nbNum = numericalsList.length;
        Document myDom = this.myFinalProduct.getMetaXml();
        int nbXmlNum = myDom.getElementsByTagName("numerical").getLength();
        System.out.println(XmlUtils.saveXML(myDom));
        FinalProductTest.assertEquals(nbNum, nbXmlNum);
    }

    public void testRemoveNumericalToXml() {
        File[] numericalsList = this.myFinalProduct.getNumericals();
        int nbNum = numericalsList.length;
        this.myFinalProduct.removeNumerical(numericalsList[0]);
        Document myDom = this.myFinalProduct.getMetaXml();
        int nbXmlNum = myDom.getElementsByTagName("numerical").getLength();
        FinalProductTest.assertEquals(nbNum - 1, nbXmlNum);
    }

    public void testAddNumericalsToXml() {
        File[] numericalsList = this.myFinalProduct.getNumericals();
        int nbNum = numericalsList.length;
        Document myDom = this.myFinalProduct.getMetaXml();
        this.myFinalProduct.addNumericals(numericalsList);
        int i = 0;
        while (i < 12) {
            myDom = this.myFinalProduct.getMetaXml();
            ++i;
        }
        int nbXmlNum = myDom.getElementsByTagName("numerical").getLength();
        FinalProductTest.assertEquals(nbNum, nbXmlNum);
    }

    public void testChangeSaveLoad() {
        ContextModel aContext = new ContextModel();
        aContext.loadXML(new File(this.baseDirName, "Context1.xml"));
        FinalProduct aProduct = new FinalProduct(new ContextModel("emptyContext"));
        aProduct.setContext(aContext);
        try {
            this.resultFile = aProduct.toZip();
        }
        catch (Exception e) {
            FinalProductTest.fail(e.getMessage());
        }
        FinalProduct anotherProduct = new FinalProduct(new ContextModel());
        try {
            anotherProduct.loadZip(this.resultFile);
        }
        catch (WrongAttachmentAttribute e) {
            FinalProductTest.fail(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FinalProductTest.assertEquals(aProduct.getName(), anotherProduct.getName());
    }

    public void testLoadChangeSaveAttachs() throws WrongProductFileException, ZipException, WrongAttachmentAttribute, IOException {
        this.myFinalProduct.loadZip(this.inputFile);
        ContextModel aContext = new ContextModel();
        aContext.loadXML(new File(this.baseDirName, "Context1.xml"));
        this.myFinalProduct.setContext(aContext);
        try {
            this.resultFile = this.myFinalProduct.toZip();
        }
        catch (Exception e) {
            e.printStackTrace();
            FinalProductTest.fail(e.getMessage());
        }
    }

    public void testDoubleSave() {
        ArrayList<File> fsDirs = new ArrayList<File>();
        int i = 0;
        while (i < 10) {
            try {
                fsDirs.add(this.myFinalProduct.toFS());
            }
            catch (Exception e) {
                e.printStackTrace();
                FinalProductTest.assertFalse("shouldnt raise " + e.getMessage(), true);
            }
            ++i;
        }
        for (File fsDir : fsDirs) {
            FileCopy.RecurseDelete(fsDir);
        }
        FinalProductTest.assertTrue(true);
    }

    private class MyListener
    implements FinalListener {
        public boolean modelChanged = false;

        private MyListener() {
        }

        @Override
        public void finalChanged(ProductChangedEvent event) {
            this.modelChanged = true;
        }
    }
}

