/*
 * Decompiled with CFR 0.152.
 */
package models;

import futils.XmlUtils;
import java.io.File;
import java.util.Observable;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import models.ContextModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextList
extends Observable {
    private EventListenerList listeners = new EventListenerList();
    private TreeMap<String, ContextModel> myMap = new TreeMap();
    private String fileName = "CgdlContextList.xml";
    private String selectedContext = null;

    public ContextList() {
    }

    public ContextList(File xmlContextList) {
        this();
        this.load(xmlContextList);
    }

    public File getDiskModel() {
        return new File(this.fileName);
    }

    public Boolean isAvailable(String searchedName) {
        String[] stringArray = this.getNamesList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(searchedName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getAvailable(String searchedName) {
        String[] stringArray = this.getNamesList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ContextModel theContext = this.myMap.get(name);
            if (name.equals(searchedName)) {
                String nextSearchedName = theContext.nextName();
                return this.getAvailable(nextSearchedName);
            }
            ++n2;
        }
        return searchedName;
    }

    public ContextModel getContext(String name) {
        return name == null ? new ContextModel() : this.myMap.get(name).clone();
    }

    public ContextModel getSelectedContext() {
        return this.getContext(this.getSelected());
    }

    public String[] getNamesList() {
        Set<String> theKeySet = this.myMap.keySet();
        String[] res = new String[theKeySet.size()];
        int i = 0;
        Object[] objectArray = theKeySet.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            res[i++] = (String)o;
            ++n2;
        }
        return res;
    }

    public boolean load() {
        return this.load(new File(this.fileName));
    }

    public boolean load(File storedList) {
        boolean result = true;
        if (storedList.exists()) {
            this.loadXML(storedList);
        } else {
            this.save();
        }
        return result;
    }

    public File save() {
        File resFile = this.saveXML(this.fileName);
        return resFile;
    }

    public Document toXML() {
        Document dom = XmlUtils.GetDocument();
        Element rootElement = dom.createElement("contextList");
        for (ContextModel context : this.myMap.values()) {
            rootElement.appendChild(dom.importNode(context.toXML().getDocumentElement(), true));
        }
        dom.appendChild(rootElement);
        return dom;
    }

    public void loadXML(File xmlFile) {
        Document dom = XmlUtils.readXML(xmlFile);
        this.deleteAll();
        NodeList allContexts = dom.getElementsByTagName("context");
        int i = 0;
        while (i < allContexts.getLength()) {
            Node contextNode = allContexts.item(i);
            ContextModel contextModel = new ContextModel(XmlUtils.Node2Dom(contextNode));
            this.addContext(contextModel);
            ++i;
        }
        this.save();
    }

    public File saveXML(String filename) {
        return XmlUtils.saveXML(this.toXML(), filename);
    }

    public boolean hasContext(String name) {
        return this.myMap.containsKey(name);
    }

    public boolean hasContext(ContextModel theModel) {
        return this.hasContext(theModel.getName());
    }

    public int getSize() {
        return this.myMap.size();
    }

    public void fireUpdate() {
        this.setChanged();
        this.notifyObservers(this);
    }

    public String addContext(ContextModel theContext) {
        ContextModel ourContext = theContext.clone();
        String name = ourContext.getName();
        this.myMap.put(name, ourContext);
        this.setSelected(name);
        this.save();
        this.fireUpdate();
        return name;
    }

    public void deleteContext(String selectedItem) {
        this.myMap.remove(selectedItem);
        this.save();
        this.fireUpdate();
    }

    public void deleteAll() {
        this.myMap.clear();
        this.save();
        this.fireUpdate();
    }

    public boolean checkConsistency() {
        boolean res = true;
        String[] stringArray = this.getNamesList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            res &= name.equals(this.getContext(name).getName());
            ++n2;
        }
        return res;
    }

    public String getSelected() {
        return this.selectedContext;
    }

    public void setSelected(String selectedItem) {
        this.selectedContext = selectedItem;
        this.fireUpdate();
    }
}

