/*
 * Decompiled with CFR 0.152.
 */
package gutils;

import exceptions.WrongValueException;
import gutils.ComponentMap;
import gutils.FormObserver;
import gutils.HLinkBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public abstract class FormPanel
extends JPanel {
    FormObserver _observer;
    ComponentMap formMap = new ComponentMap();
    boolean _checkState;
    protected static Border RADIO_BORDER = BorderFactory.createEtchedBorder(1);

    public FormPanel(FormObserver fo) {
        this.setFormObserver(fo);
    }

    public void fireUpdate() {
        this._observer.formChanged(this);
    }

    public void setFormObserver(FormObserver fo) {
        this._observer = fo;
    }

    public ComponentMap getMap() {
        return this.formMap;
    }

    public void checkForm() {
        try {
            this.setVerified(this.formMap.checkComponents());
        }
        catch (WrongValueException wve) {
            JOptionPane.showMessageDialog(this, wve.getMessage());
            this.setVerified(false);
        }
        this.fireUpdate();
    }

    public boolean isVerified() {
        return this._checkState;
    }

    public void setVerified(boolean checkState) {
        this._checkState = checkState;
    }

    public JComponent getCheckerButton() {
        JButton theCheckerBtn = new JButton("Next");
        theCheckerBtn.addActionListener(new CheckerListener());
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            JComponent aJComp = (JComponent)comp;
            aJComp.resetKeyboardActions();
            aJComp.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "check");
            aJComp.getActionMap().put("check", new CheckerListener());
            ++n2;
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "check");
        this.getActionMap().put("check", new CheckerListener());
        JButton theResetterBtn = new JButton("Reset It");
        theResetterBtn.addActionListener(new ResetterListener());
        HLinkBox checkerBox = new HLinkBox(new Component[]{theResetterBtn, Box.createHorizontalGlue(), theCheckerBtn});
        return checkerBox;
    }

    public void fixHeadingLabel(JLabel myLabel) {
        myLabel.setForeground(Color.BLUE);
        myLabel.setFont(new Font("sans", 1, 14));
    }

    public class CheckerListener
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            FormPanel.this.checkForm();
        }
    }

    public class ResetterListener
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            FormPanel.this.getMap().resetValues();
            FormPanel.this.checkForm();
        }
    }
}

