/*
 * Decompiled with CFR 0.152.
 */
package gutils;

import exceptions.WrongValueException;
import gutils.ComponentMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import junit.framework.TestCase;
import models.ComponentKey;
import models.ContextKey;

public class ComponentMapTest
extends TestCase {
    ComponentMap myComponentMap;

    public ComponentMapTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myComponentMap = new ComponentMap();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testComponentMap() {
    }

    public void testComponentMapContextKeysMap() {
    }

    public void testSetComponentValue() {
    }

    public void testGetJTextArea() {
        JTextArea myTA = new JTextArea("NANA");
        try {
            this.myComponentMap.put(ContextKey.LOCATION, myTA);
        }
        catch (ClassCastException e) {
            ComponentMapTest.fail("shouldnt raise " + e.getMessage());
        }
    }

    public void testGetUnselectedValue() {
        JRadioButton myRB1 = new JRadioButton("RB1");
        myRB1.setActionCommand("RB1");
        JRadioButton myRB2 = new JRadioButton("RB2");
        myRB2.setActionCommand("RB2");
        ButtonGroup myGrp = new ButtonGroup();
        this.myComponentMap.put(new MyComponentKey("RB"), myGrp);
        try {
            this.myComponentMap.getComponentValue(new MyComponentKey("UnknownKey"));
        }
        catch (NullPointerException e) {
            ComponentMapTest.fail("shouldnt raise null pointer");
        }
    }

    public void testGetValueMap() {
    }

    public void testSetValueMap() {
    }

    public void testCheckComponents() {
        JLabel myLblo = new JLabel("OH");
        JLabel myLbla = new JLabel("HA");
        MyComponentKey o = new MyComponentKey("O");
        MyComponentKey a = new MyComponentKey("A");
        this.myComponentMap.put(o, myLblo);
        this.myComponentMap.put(a, myLbla);
        boolean res = false;
        try {
            res = this.myComponentMap.checkComponents(new MyComponentKey[]{o, a});
        }
        catch (WrongValueException e) {
            e.printStackTrace();
        }
        ComponentMapTest.assertTrue(res);
    }

    public class MyComponentKey
    implements ComponentKey {
        String name;

        public MyComponentKey(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isValid(Object value) {
            int stringLgth = ((String)value).length();
            System.out.println(stringLgth);
            return stringLgth == 2;
        }

        @Override
        public String getErrMessage() {
            return "no err message";
        }

        @Override
        public boolean isMandatory() {
            return false;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }
    }
}

