/*
 * Decompiled with CFR 0.152.
 */
package models;

import futils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import models.ContextKey;
import models.ContextKeysMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ContextModel
implements Serializable,
Cloneable {
    private String contextName;
    private static String INC_ATTR_NAME = "nameCount";
    private final ContextKeysMap myMap = new ContextKeysMap();
    Document myDom;
    int increment = 0;

    public Element getRootNode() {
        Element rootElement = this.myDom.createElement("context");
        rootElement.setAttribute(INC_ATTR_NAME, Integer.toString(this.increment));
        rootElement.setAttribute("version", "0.4.1");
        return rootElement;
    }

    public ContextModel(Map namesMap) {
        if (namesMap == null) {
            namesMap = new ContextKeysMap();
        }
        this.setMap(namesMap);
        this.myDom = XmlUtils.GetDocument();
    }

    public ContextModel() {
        this((Map)null);
    }

    public ContextModel(String name) {
        this(new ContextKeysMap());
    }

    public ContextModel(ContextModel theModel) {
        this(theModel.getMap());
        this.increment = theModel.increment;
    }

    public ContextModel(Document dom) {
        this.loadXML(dom);
    }

    public ContextModel clone() {
        ContextModel resModel = new ContextModel((ContextKeysMap)this.getMap().clone());
        resModel.increment = this.increment;
        return resModel;
    }

    public void setName(String name) {
        this.contextName = name;
    }

    public String getName() {
        String date = (String)this.myMap.get(ContextKey.CONTENT_DATE);
        String place = (String)this.myMap.get(ContextKey.LOCATION);
        String atmos = (String)this.myMap.get(ContextKey.ATM_COMPOSITION);
        String source = (String)this.myMap.get(ContextKey.SOURCE);
        String target = (String)this.myMap.get(ContextKey.TARGET_NAME);
        String distance = (String)this.myMap.get(ContextKey.DISTANCE);
        String distance_unit = (String)this.myMap.get(ContextKey.DISTANCE_UNIT);
        this.contextName = String.format("%-5s %-8s %-15s %-5s %-5s %5s%2s %03d", source, date, target, atmos, place, distance, distance_unit, this.increment);
        this.contextName = this.contextName.replace(' ', '_');
        this.contextName = this.contextName.replace('/', '_');
        this.contextName = this.contextName.replace('\\', '_');
        return this.contextName;
    }

    public String nextName() {
        ++this.increment;
        return this.getName();
    }

    public void resetIncrement() {
        this.increment = 0;
    }

    public void setMap(Map namesMap) {
        for (Object key : namesMap.keySet()) {
            String keyName = key.toString();
            try {
                ContextKey ourKey = Enum.valueOf(ContextKey.class, keyName.toUpperCase());
                String value = namesMap.get(key).toString();
                this.myMap.put(ourKey, value);
            }
            catch (IllegalArgumentException e) {
                System.err.println(String.valueOf(keyName) + " not allowed as context key: " + e.getMessage());
            }
            catch (NullPointerException e) {
                System.err.println("no such key " + keyName);
            }
        }
    }

    public void putKey(ContextKey key, String value) {
        this.myMap.put(key, value);
    }

    public ContextKeysMap getMap() {
        return this.myMap;
    }

    public Document toXML() {
        ContextKeysMap myMap = this.getMap();
        Element myContextNode = this.getRootNode();
        for (ContextKey thisKey : myMap.keySet()) {
            String thisValue = (String)myMap.get(thisKey);
            Element thisElement = this.myDom.createElement(thisKey.getName());
            thisElement.setTextContent(thisValue);
            myContextNode.appendChild(thisElement);
        }
        Element rootNode = this.myDom.getDocumentElement();
        if (rootNode == null) {
            this.myDom.appendChild(myContextNode);
        } else {
            this.myDom.replaceChild(myContextNode, rootNode);
        }
        return this.myDom;
    }

    public Document getDom() {
        return this.myDom;
    }

    public void loadXML(File xmlfile) {
        try {
            this.myDom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlfile);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.loadXML(XmlUtils.readXML(xmlfile));
    }

    public void loadXML(Document dom) {
        this.myDom = dom;
        String incString = ((Element)dom.getElementsByTagName("context").item(0)).getAttribute(INC_ATTR_NAME);
        this.increment = incString.length() > 0 ? Integer.parseInt(incString) : 0;
        TreeMap<String, String> aContextMap = this.dom2ContextMap(this.myDom);
        this.setMap(aContextMap);
    }

    public TreeMap<String, String> dom2ContextMap(Document theDom) {
        TreeMap<String, String> resMap = new TreeMap<String, String>();
        Node contextElement = theDom.getElementsByTagName("context").item(0);
        NodeList contextChilds = contextElement.getChildNodes();
        int i = 0;
        while (i < contextChilds.getLength()) {
            Node child = contextChilds.item(i);
            if (1 == child.getNodeType()) {
                String value;
                String name = child.getNodeName();
                try {
                    value = child.getFirstChild().getNodeValue();
                }
                catch (NullPointerException e) {
                    value = "no value";
                }
                resMap.put(name, value);
            }
            ++i;
        }
        return resMap;
    }

    public String toString() {
        this.toXML();
        return XmlUtils.saveXML(this.myDom);
    }

    public File saveXML() {
        return XmlUtils.saveXML(this.myDom, String.valueOf(this.getName()) + ".xml");
    }
}

