/*
 * Decompiled with CFR 0.152.
 */
package models;

import exceptions.WrongAttachmentAttribute;
import futils.XmlUtils;
import java.io.File;
import models.AttachmentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AttachmentData {
    static final String DEFAULT_LINK = "none";
    static final String DEFAULT_COMMENT = "Default Comment";
    static final AttachmentType DEFAULT_TYPE = AttachmentType.OTHER;
    private String _link = "none";
    String comment;
    AttachmentType type;
    File dataFile;
    File baseDir = null;

    public AttachmentData(File dataFile, String comment, AttachmentType type) {
        this.setUp(dataFile, comment, type);
    }

    public AttachmentData(Element attachementElement, File baseDir) throws WrongAttachmentAttribute {
        this.baseDir = baseDir;
        this.loadNode(attachementElement);
    }

    public AttachmentData(File dataFile) {
        this(dataFile, DEFAULT_COMMENT, DEFAULT_TYPE);
    }

    public void setUp(File dataFile, String comment, AttachmentType type) {
        this.dataFile = dataFile;
        this.baseDir = dataFile.getParentFile();
        this.comment = comment;
        this.type = type;
    }

    public void setUp(File dataFile, String comment, String type) throws WrongAttachmentAttribute {
        this.dataFile = dataFile;
        this.baseDir = dataFile.getParentFile();
        this.comment = comment;
        this.setType(type);
    }

    public File getFile() {
        return this.dataFile;
    }

    public void setFile(File theFile) {
        this.dataFile = theFile;
    }

    public String getLink() {
        return this._link;
    }

    public void setLink(String linkname) {
        this._link = linkname;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public void setType(String typeString) throws WrongAttachmentAttribute {
        AttachmentType typeWanted;
        try {
            typeWanted = AttachmentType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            typeWanted = DEFAULT_TYPE;
        }
        this.type = typeWanted;
    }

    public void loadNode(Element numericalElement) throws WrongAttachmentAttribute {
        File file;
        String fileName = numericalElement.getElementsByTagName("name").item(0).getTextContent();
        String comment = numericalElement.getElementsByTagName("comment").item(0).getTextContent();
        String typeString = numericalElement.getElementsByTagName("type").item(0).getTextContent();
        String linkString = DEFAULT_LINK;
        if (numericalElement.getElementsByTagName("link").item(0) != null) {
            linkString = numericalElement.getElementsByTagName("link").item(0).getTextContent();
        }
        if (!(file = new File(this.baseDir, fileName)).exists()) {
            throw new WrongAttachmentAttribute("no such file: " + file.getPath());
        }
        this.setLink(linkString);
        this.setUp(file, comment, typeString);
    }

    public Element toNode() {
        Document aDoc = XmlUtils.GetDocument();
        Element numericalNode = aDoc.createElement("numerical");
        Element nameNode = aDoc.createElement("name");
        Element sizeNode = aDoc.createElement("size");
        Element commentNode = aDoc.createElement("comment");
        Element typeNode = aDoc.createElement("type");
        Element linkNode = aDoc.createElement("link");
        String fileName = this.dataFile.getName();
        nameNode.setTextContent(fileName);
        sizeNode.setTextContent(String.valueOf(this.dataFile.length()));
        commentNode.setTextContent(this.comment);
        typeNode.setTextContent(this.type.toString());
        linkNode.setTextContent(this._link);
        numericalNode.appendChild(nameNode);
        numericalNode.appendChild(sizeNode);
        numericalNode.appendChild(commentNode);
        numericalNode.appendChild(typeNode);
        numericalNode.appendChild(linkNode);
        return numericalNode;
    }
}

